/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import org.geneweaver.domain.AbstractEntity;
import org.geneweaver.domain.HomologGene;
import org.neo4j.ogm.annotation.EndNode;
import org.neo4j.ogm.annotation.RelationshipEntity;
import org.neo4j.ogm.annotation.StartNode;

@RelationshipEntity(type="HOMOLOG")
public class Homolog
extends AbstractEntity {
    private Long hid;
    @StartNode
    private HomologGene speciesFrom;
    @EndNode
    private HomologGene speciesTo;
    private String source;
    private String geneIdFrom;
    private String geneIdTo;

    public Homolog() {
        this.setChr("NO-CHROMOSOME", true);
    }

    public Homolog(Long hid, String geneIdFrom, String geneIdTo) {
        this();
        this.hid = hid;
        this.geneIdFrom = geneIdFrom;
        this.geneIdTo = geneIdTo;
    }

    public Homolog(HomologGene from, HomologGene to) {
        this();
        this.speciesFrom = from;
        this.speciesTo = to;
    }

    @Override
    public String getHeader() {
        StringBuilder buf = new StringBuilder();
        buf.append(":START_ID(Gene-Id)");
        buf.append(this.getDelimiter());
        buf.append("homologId");
        buf.append(this.getDelimiter());
        buf.append("source");
        buf.append(this.getDelimiter());
        buf.append(":END_ID(Gene-Id)");
        buf.append(this.getDelimiter());
        buf.append(":TYPE");
        return buf.toString();
    }

    @Override
    public String toCsv() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getGeneIdFrom());
        buf.append(this.getDelimiter());
        buf.append(this.getHid());
        buf.append(this.getDelimiter());
        buf.append(this.getSource());
        buf.append(this.getDelimiter());
        buf.append(this.getGeneIdTo());
        buf.append(this.getDelimiter());
        buf.append(this.getClass().getSimpleName().toUpperCase());
        return buf.toString();
    }

    protected String getGeneIdFrom() {
        String id;
        if (this.geneIdFrom == null && this.speciesFrom == null) {
            return null;
        }
        String string = id = this.geneIdFrom != null ? this.geneIdFrom : this.speciesFrom.getGeneId();
        if (id == null) {
            throw new IllegalArgumentException("The geneid must not be null!");
        }
        return id;
    }

    protected String getGeneIdTo() {
        String id;
        if (this.geneIdTo == null && this.speciesTo == null) {
            return null;
        }
        String string = id = this.geneIdTo != null ? this.geneIdTo : this.speciesTo.getGeneId();
        if (id == null) {
            throw new IllegalArgumentException("The geneid must not be null!");
        }
        return id;
    }

    public HomologGene getSpeciesFrom() {
        return this.speciesFrom;
    }

    public void setSpeciesFrom(HomologGene speciesFrom) {
        this.speciesFrom = speciesFrom;
    }

    public HomologGene getSpeciesTo() {
        return this.speciesTo;
    }

    public void setSpeciesTo(HomologGene speciesTo) {
        this.speciesTo = speciesTo;
    }

    @Override
    public String toString() {
        return this.getGeneIdFrom() + "-[" + this.getClass().getSimpleName().toUpperCase() + "]->" + this.getGeneIdTo();
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public Long getHid() {
        return this.hid;
    }

    public void setHid(Long hid) {
        this.hid = hid;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.geneIdFrom, this.geneIdTo, this.hid, this.source, this.speciesFrom, this.speciesTo);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Homolog)) {
            return false;
        }
        Homolog other = (Homolog)obj;
        return Objects.equals(this.geneIdFrom, other.geneIdFrom) && Objects.equals(this.geneIdTo, other.geneIdTo) && Objects.equals(this.hid, other.hid) && Objects.equals(this.source, other.source) && Objects.equals(this.speciesFrom, other.speciesFrom) && Objects.equals(this.speciesTo, other.speciesTo);
    }

    @Override
    @JsonIgnore
    public void setChr(String chr) {
        super.setChr(chr);
    }

    @Override
    @JsonIgnore
    public String getChr() {
        return super.getChr();
    }
}

