/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import org.geneweaver.domain.AbstractEntity;
import org.geneweaver.domain.Gene;
import org.neo4j.ogm.annotation.EndNode;
import org.neo4j.ogm.annotation.RelationshipEntity;
import org.neo4j.ogm.annotation.StartNode;

@RelationshipEntity(type="ORTHOLOG")
public class Ortholog
extends AbstractEntity {
    @StartNode
    private Gene speciesFrom;
    @EndNode
    private Gene speciesTo;
    private String geneIdFrom;
    private String geneIdTo;
    private String source;
    private Integer mgi = -1;
    private Integer hgnc = -1;

    public Ortholog(String from, String to) {
        this();
        this.geneIdFrom = from;
        this.geneIdTo = to;
    }

    public Ortholog(Gene from, Gene to) {
        this();
        this.speciesFrom = from;
        this.speciesTo = to;
    }

    public Ortholog() {
        this.setChr("NO-CHROMOSOME", true);
    }

    @Override
    public String getHeader() {
        StringBuilder buf = new StringBuilder();
        buf.append(":START_ID(Gene-Id)");
        buf.append(this.getDelimiter());
        buf.append("source");
        buf.append(this.getDelimiter());
        buf.append("mgi");
        buf.append(this.getDelimiter());
        buf.append("hgnc");
        buf.append(this.getDelimiter());
        buf.append(":END_ID(Gene-Id)");
        buf.append(this.getDelimiter());
        buf.append(":TYPE");
        return buf.toString();
    }

    @Override
    public String toCsv() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getSpeciesFromId());
        buf.append(this.getDelimiter());
        buf.append(this.getSource());
        buf.append(this.getDelimiter());
        buf.append(this.getMgi());
        buf.append(this.getDelimiter());
        buf.append(this.getHgnc());
        buf.append(this.getDelimiter());
        buf.append(this.getSpeciesToId());
        buf.append(this.getDelimiter());
        buf.append(this.getClass().getSimpleName().toUpperCase());
        return buf.toString();
    }

    public Gene getSpeciesFrom() {
        return this.speciesFrom;
    }

    public void setSpeciesFrom(Gene speciesFrom) {
        this.speciesFrom = speciesFrom;
    }

    public Gene getSpeciesTo() {
        return this.speciesTo;
    }

    public void setSpeciesTo(Gene speciesTo) {
        this.speciesTo = speciesTo;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.geneIdFrom, this.geneIdTo, this.hgnc, this.mgi, this.source, this.speciesFrom, this.speciesTo);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Ortholog)) {
            return false;
        }
        Ortholog other = (Ortholog)obj;
        return Objects.equals(this.geneIdFrom, other.geneIdFrom) && Objects.equals(this.geneIdTo, other.geneIdTo) && Objects.equals(this.hgnc, other.hgnc) && Objects.equals(this.mgi, other.mgi) && Objects.equals(this.source, other.source) && Objects.equals(this.speciesFrom, other.speciesFrom) && Objects.equals(this.speciesTo, other.speciesTo);
    }

    protected String getSpeciesFromId() {
        return this.speciesFrom != null ? this.speciesFrom.getGeneId() : this.geneIdFrom;
    }

    protected String getSpeciesToId() {
        return this.speciesTo != null ? this.speciesTo.getGeneId() : this.geneIdTo;
    }

    @Override
    public String toString() {
        return this.getSpeciesFromId() + "-[ORTHOLOG]->" + this.getSpeciesToId();
    }

    public String getSource() {
        return this.source;
    }

    public Ortholog setSource(String source) {
        this.source = source;
        return this;
    }

    public Integer getMgi() {
        return this.mgi;
    }

    public void setMgi(Integer mgi) {
        this.mgi = mgi;
    }

    public Integer getHgnc() {
        return this.hgnc;
    }

    public void setHgnc(Integer hgnc) {
        this.hgnc = hgnc;
    }

    @JsonIgnore
    public String getGeneIdFrom() {
        return this.geneIdFrom;
    }

    @JsonIgnore
    public String getGeneIdTo() {
        return this.geneIdTo;
    }

    @Override
    @JsonIgnore
    public void setChr(String chr) {
        super.setChr(chr);
    }

    @Override
    @JsonIgnore
    public String getChr() {
        return super.getChr();
    }
}

