/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Arrays;
import java.util.Objects;
import org.geneweaver.domain.Located;
import org.geneweaver.domain.NamedEntity;
import org.geneweaver.domain.Species;
import org.neo4j.ogm.annotation.Index;
import org.neo4j.ogm.annotation.NodeEntity;

@NodeEntity(label="Peak")
public class Peak
extends NamedEntity
implements Located {
    @Index(unique=true)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String peakId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String epigenome;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String tissueDescription;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String filterType;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String featureType;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer start;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer end;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private int score;
    private Strand strand;
    private int thickStart;
    private int thickEnd;
    private int[] itemRgb;
    private int blockCount;
    private int[] blockSizes;
    private int[] blockStarts;

    public Peak() {
    }

    public Peak(String name) {
        this.setName(name);
    }

    public Peak(String peakId, String species, String chr, int start, int end, String name, int score, Strand strand, int thickStart, int thickEnd) {
        this.peakId = peakId;
        this.setSpecies(Species.code(species));
        this.setChr(chr);
        this.start = start;
        this.end = end;
        this.setName(name);
        this.score = score;
        this.strand = strand;
        this.thickStart = thickStart;
        this.thickEnd = thickEnd;
    }

    public Peak(String speakId, int low, int high) {
        this.peakId = speakId;
        this.start = low;
        this.end = high;
    }

    @Override
    public String getHeader() {
        StringBuilder buf = new StringBuilder();
        String fields = this.delimify("peakId:ID(Peak-Id)", "species:int", "featureType", "epigenome", "start:int", "end:int", "chr", "score:int", "strand", ":LABEL");
        buf.append(fields);
        String sheader = super.getHeader();
        if (sheader != null) {
            buf.append(this.getDelimiter());
            buf.append(sheader);
        }
        return buf.toString();
    }

    @Override
    public String toCsv() {
        StringBuilder buf = new StringBuilder();
        String values = this.delimify(this.getPeakId(), this.getSpecies(), this.getFeatureType(), this.getEpigenome(), this.getStart(), this.getEnd(), this.getChr(), this.getScore(), this.strandCharacter(this.getStrand()), this.getClass().getSimpleName().toString());
        buf.append(values);
        String scsv = super.toCsv();
        if (scsv != null) {
            buf.append(this.getDelimiter());
            buf.append(scsv);
        }
        return buf.toString();
    }

    @JsonIgnore
    private String strandCharacter(Strand s) {
        if (s == null) {
            return null;
        }
        return s.toString();
    }

    @Override
    public Integer getStart() {
        return this.start;
    }

    public void setStart(Integer start) {
        this.start = start;
    }

    @Override
    public Integer getEnd() {
        return this.end;
    }

    public void setEnd(Integer end) {
        this.end = end;
    }

    public int getScore() {
        return this.score;
    }

    public void setScore(int score) {
        this.score = score;
    }

    public Strand getStrand() {
        return this.strand;
    }

    public void setStrand(Strand strand) {
        this.strand = strand;
    }

    public int getThickStart() {
        return this.thickStart;
    }

    public void setThickStart(int thickStart) {
        this.thickStart = thickStart;
    }

    public int getThickEnd() {
        return this.thickEnd;
    }

    public void setThickEnd(int thickEnd) {
        this.thickEnd = thickEnd;
    }

    public int[] getItemRgb() {
        return this.itemRgb;
    }

    public void setItemRgb(int[] itemRgb) {
        this.itemRgb = itemRgb;
    }

    public int getBlockCount() {
        return this.blockCount;
    }

    public void setBlockCount(int blockCount) {
        this.blockCount = blockCount;
    }

    public int[] getBlockSizes() {
        return this.blockSizes;
    }

    public void setBlockSizes(int ... blockSizes) {
        this.blockSizes = blockSizes;
    }

    public int[] getBlockStarts() {
        return this.blockStarts;
    }

    public void setBlockStarts(int ... blockStarts) {
        this.blockStarts = blockStarts;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.blockSizes);
        result = 31 * result + Arrays.hashCode(this.blockStarts);
        result = 31 * result + Arrays.hashCode(this.itemRgb);
        result = 31 * result + Objects.hash(new Object[]{this.blockCount, this.end, this.epigenome, this.featureType, this.filterType, this.peakId, this.score, this.start, this.strand, this.thickEnd, this.thickStart, this.tissueDescription});
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Peak)) {
            return false;
        }
        Peak other = (Peak)obj;
        return this.blockCount == other.blockCount && Arrays.equals(this.blockSizes, other.blockSizes) && Arrays.equals(this.blockStarts, other.blockStarts) && Objects.equals(this.end, other.end) && Objects.equals(this.epigenome, other.epigenome) && Objects.equals(this.featureType, other.featureType) && Objects.equals(this.filterType, other.filterType) && Arrays.equals(this.itemRgb, other.itemRgb) && Objects.equals(this.peakId, other.peakId) && this.score == other.score && Objects.equals(this.start, other.start) && this.strand == other.strand && this.thickEnd == other.thickEnd && this.thickStart == other.thickStart && Objects.equals(this.tissueDescription, other.tissueDescription);
    }

    public String getPeakId() {
        return this.peakId;
    }

    public void setPeakId(String peakId) {
        this.peakId = peakId;
    }

    public String getEpigenome() {
        return this.epigenome;
    }

    public void setEpigenome(String epigenome) {
        this.epigenome = epigenome;
    }

    public String getTissueDescription() {
        return this.tissueDescription;
    }

    public void setTissueDescription(String tissueDescription) {
        this.tissueDescription = tissueDescription;
    }

    public String getFeatureType() {
        return this.featureType;
    }

    public void setFeatureType(String featureType) {
        this.featureType = featureType;
    }

    public String getFilterType() {
        return this.filterType;
    }

    public void setFilterType(String filterType) {
        this.filterType = filterType;
    }

    @Override
    public String id() {
        return this.getPeakId();
    }

    public static enum Strand {
        FORWARD,
        REVERSE;


        public static Strand from(String seg) {
            if ("+".equals(seg)) {
                return FORWARD;
            }
            if ("-".equals(seg)) {
                return REVERSE;
            }
            return null;
        }

        public String toString() {
            if (this == FORWARD) {
                return "+";
            }
            if (this == REVERSE) {
                return "-";
            }
            return null;
        }
    }
}

