/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.domain;

import java.util.Objects;
import org.geneweaver.domain.AbstractEntity;
import org.geneweaver.domain.Located;
import org.neo4j.ogm.annotation.EndNode;
import org.neo4j.ogm.annotation.RelationshipEntity;
import org.neo4j.ogm.annotation.StartNode;

@RelationshipEntity(type="PEAK_OVERLAP")
public class PeakOverlap
extends AbstractEntity {
    @StartNode
    private Located variant;
    @EndNode
    private Located peak;

    @Override
    public String getHeader() {
        StringBuilder buf = new StringBuilder();
        buf.append(":START_ID(Rs-Id)");
        buf.append(this.getDelimiter());
        buf.append(":END_ID(Peak-Id)");
        buf.append(this.getDelimiter());
        buf.append(":TYPE");
        return buf.toString();
    }

    @Override
    public String toCsv() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.variant != null ? this.variant.id() : "NA");
        buf.append(this.getDelimiter());
        buf.append(this.peak != null ? this.peak.id() : "NA");
        buf.append(this.getDelimiter());
        buf.append("PEAK_OVERLAP");
        return buf.toString();
    }

    public Located getVariant() {
        return this.variant;
    }

    public void setVariant(Located variant) {
        this.variant = variant;
    }

    public Located getPeak() {
        return this.peak;
    }

    public void setPeak(Located peak) {
        this.peak = peak;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.peak, this.variant);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof PeakOverlap)) {
            return false;
        }
        PeakOverlap other = (PeakOverlap)obj;
        return Objects.equals(this.peak, other.peak) && Objects.equals(this.variant, other.variant);
    }

    @Override
    public String toString() {
        if (this.variant == null || this.peak == null) {
            return super.toString();
        }
        return "(Variant{rsId:" + this.variant.id() + "})-[PEAK_OVERLAP]-(Peak{peakId:" + this.peak.id() + ")";
    }
}

