/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.domain;

import java.util.Objects;
import org.geneweaver.domain.AbstractEntity;
import org.geneweaver.domain.Gene;
import org.geneweaver.domain.Transcript;
import org.neo4j.ogm.annotation.EndNode;
import org.neo4j.ogm.annotation.RelationshipEntity;
import org.neo4j.ogm.annotation.StartNode;

@RelationshipEntity(type="PRODUCES")
public class Produces
extends AbstractEntity {
    @StartNode
    private Gene gene;
    @EndNode
    private Transcript transcript;

    public Produces() {
    }

    public Produces(Gene gene, Transcript transcript) {
        this.gene = gene;
        this.transcript = transcript;
    }

    @Override
    public String getHeader() {
        StringBuilder buf = new StringBuilder();
        buf.append(":START_ID(Gene-Id)");
        buf.append(this.getDelimiter());
        buf.append(":END_ID(Transcript-Id)");
        buf.append(this.getDelimiter());
        buf.append(":TYPE");
        return buf.toString();
    }

    @Override
    public String toCsv() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.gene.getGeneId());
        buf.append(this.getDelimiter());
        buf.append(this.transcript.getTranscriptId());
        buf.append(this.getDelimiter());
        buf.append(this.getClass().getSimpleName().toUpperCase());
        return buf.toString();
    }

    public Gene getGene() {
        return this.gene;
    }

    public void setGene(Gene gene) {
        this.gene = gene;
    }

    public Transcript getTranscript() {
        return this.transcript;
    }

    public void setTranscript(Transcript transcript) {
        this.transcript = transcript;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.gene, this.transcript);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Produces)) {
            return false;
        }
        Produces other = (Produces)obj;
        return Objects.equals(this.gene, other.gene) && Objects.equals(this.transcript, other.transcript);
    }

    @Override
    public String toString() {
        String geneId = this.gene != null ? this.gene.getGeneId() : null;
        String transId = this.transcript != null ? this.transcript.getTranscriptId() : null;
        return geneId + "-[PRODUCES]->" + transId;
    }
}

