/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.domain;

import java.util.Objects;
import org.geneweaver.domain.GeneticEntity;
import org.neo4j.ogm.annotation.Index;
import org.neo4j.ogm.annotation.NodeEntity;

@NodeEntity(label="RegulatoryFeature")
public class RegulatoryFeature
extends GeneticEntity {
    @Index(unique=true)
    private String featureId;
    private String activity;
    private int boundEnd;
    private int boundStart;
    private String description;
    private String epigenome;
    private String featureType;
    private String assemblyVersion;
    private String cellType;
    private String analysisName;
    private String resultsType;
    private String date;

    public RegulatoryFeature() {
    }

    public RegulatoryFeature(String id, int start, int end) {
        this();
        this.featureId = id;
        this.setStart(start);
        this.setEnd(end);
    }

    @Override
    public String getHeader() {
        StringBuilder buf = new StringBuilder();
        buf.append("featureId:ID(Feature-Id)");
        buf.append(this.getDelimiter());
        buf.append("activity");
        buf.append(this.getDelimiter());
        buf.append("epigenome");
        buf.append(this.getDelimiter());
        buf.append("featureType");
        buf.append(this.getDelimiter());
        buf.append("assemblyVersion");
        buf.append(this.getDelimiter());
        buf.append("cellType");
        buf.append(this.getDelimiter());
        buf.append("description");
        buf.append(this.getDelimiter());
        buf.append(super.getHeader());
        return buf.toString();
    }

    @Override
    public String toCsv() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getFeatureId());
        buf.append(this.getDelimiter());
        buf.append(this.getActivity());
        buf.append(this.getDelimiter());
        buf.append(this.getEpigenome());
        buf.append(this.getDelimiter());
        buf.append(this.getFeatureType());
        buf.append(this.getDelimiter());
        buf.append(this.getAssemblyVersion());
        buf.append(this.getDelimiter());
        buf.append(this.getCellType());
        buf.append(this.getDelimiter());
        buf.append(this.getDescription());
        buf.append(this.getDelimiter());
        buf.append(super.toCsv());
        return buf.toString();
    }

    public String getFeatureId() {
        return this.featureId;
    }

    public void setFeatureId(String featureId) {
        this.featureId = featureId;
    }

    public String getActivity() {
        return this.activity;
    }

    public void setActivity(String activity) {
        this.activity = activity;
    }

    public int getBoundEnd() {
        return this.boundEnd;
    }

    public void setBoundEnd(int boundEnd) {
        this.boundEnd = boundEnd;
    }

    public int getBoundStart() {
        return this.boundStart;
    }

    public void setBoundStart(int boundStart) {
        this.boundStart = boundStart;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getEpigenome() {
        return this.epigenome;
    }

    public void setEpigenome(String epigenome) {
        this.epigenome = epigenome;
    }

    public String getFeatureType() {
        return this.featureType;
    }

    public void setFeatureType(String featureType) {
        this.featureType = featureType;
    }

    public String getAssemblyVersion() {
        return this.assemblyVersion;
    }

    public void setAssemblyVersion(String assemblyVersion) {
        this.assemblyVersion = assemblyVersion;
    }

    public String getAnalysisName() {
        return this.analysisName;
    }

    public void setAnalysisName(String analysisName) {
        this.analysisName = analysisName;
    }

    public String getResultsType() {
        return this.resultsType;
    }

    public void setResultsType(String resultsType) {
        this.resultsType = resultsType;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.activity, this.analysisName, this.assemblyVersion, this.boundEnd, this.boundStart, this.cellType, this.date, this.description, this.epigenome, this.featureId, this.featureType, this.resultsType);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof RegulatoryFeature)) {
            return false;
        }
        RegulatoryFeature other = (RegulatoryFeature)obj;
        return Objects.equals(this.activity, other.activity) && Objects.equals(this.analysisName, other.analysisName) && Objects.equals(this.assemblyVersion, other.assemblyVersion) && this.boundEnd == other.boundEnd && this.boundStart == other.boundStart && Objects.equals(this.cellType, other.cellType) && Objects.equals(this.date, other.date) && Objects.equals(this.description, other.description) && Objects.equals(this.epigenome, other.epigenome) && Objects.equals(this.featureId, other.featureId) && Objects.equals(this.featureType, other.featureType) && Objects.equals(this.resultsType, other.resultsType);
    }

    @Override
    public String id() {
        return this.getFeatureId();
    }

    public String getCellType() {
        return this.cellType;
    }

    public void setCellType(String cellType) {
        this.cellType = cellType;
    }
}

