/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.domain;

import java.util.Objects;
import org.geneweaver.domain.AbstractEntity;
import org.geneweaver.domain.Located;
import org.neo4j.ogm.annotation.EndNode;
import org.neo4j.ogm.annotation.RelationshipEntity;
import org.neo4j.ogm.annotation.StartNode;

@RelationshipEntity(type="REGULATORY_FEATURE_OVERLAP")
public class RegulatoryFeatureOverlap
extends AbstractEntity {
    @StartNode
    private Located regFeature;
    @EndNode
    private Located variant;

    @Override
    public String getHeader() {
        StringBuilder buf = new StringBuilder();
        buf.append(":START_ID(Feature-Id)");
        buf.append(this.getDelimiter());
        buf.append(":END_ID(Rs-Id)");
        buf.append(this.getDelimiter());
        buf.append(":TYPE");
        return buf.toString();
    }

    @Override
    public String toCsv() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.regFeature != null ? this.regFeature.id() : "NA");
        buf.append(this.getDelimiter());
        buf.append(this.variant != null ? this.variant.id() : "NA");
        buf.append(this.getDelimiter());
        buf.append("REGULATORY_FEATURE_OVERLAP");
        return buf.toString();
    }

    public Located getRegFeature() {
        return this.regFeature;
    }

    public void setRegFeature(Located rfeature) {
        this.regFeature = rfeature;
    }

    public Located getVariant() {
        return this.variant;
    }

    public void setVariant(Located peak) {
        this.variant = peak;
    }

    @Override
    public String toString() {
        if (this.regFeature == null || this.variant == null) {
            return super.toString();
        }
        return "(Variant{rsId:" + this.variant.id() + "})-[REGULATORY_FEATURE_OVERLAP]-(RegulatoryFeature{featureId:" + this.regFeature.id() + ")";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.regFeature, this.variant);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof RegulatoryFeatureOverlap)) {
            return false;
        }
        RegulatoryFeatureOverlap other = (RegulatoryFeatureOverlap)obj;
        return Objects.equals(this.regFeature, other.regFeature) && Objects.equals(this.variant, other.variant);
    }
}

