/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.domain;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geneweaver.domain.AbstractEntity;

public class Sample
extends AbstractEntity
implements Comparable<Sample> {
    private String tissueGroup;
    private String tissueName;
    private String originalTissueName;
    private String tissueSecondaryGroup;
    private static final Pattern groupPattern = Pattern.compile("^(.+ \\- )(.+)$");

    public String getTissueGroup() {
        return this.tissueGroup;
    }

    public void setTissueGroup(String tissueGroup) {
        this.tissueGroup = tissueGroup;
    }

    public String getTissueName() {
        return this.tissueName;
    }

    public void setTissueName(String tissueName) {
        this.tissueName = tissueName;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.originalTissueName, this.tissueGroup, this.tissueName, this.tissueSecondaryGroup);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Sample)) {
            return false;
        }
        Sample other = (Sample)obj;
        return Objects.equals(this.originalTissueName, other.originalTissueName) && Objects.equals(this.tissueGroup, other.tissueGroup) && Objects.equals(this.tissueName, other.tissueName) && Objects.equals(this.tissueSecondaryGroup, other.tissueSecondaryGroup);
    }

    @Override
    public String toString() {
        return this.tissueGroup + " " + this.tissueName;
    }

    public boolean trim() {
        if (this.tissueName == null) {
            return false;
        }
        String frag = this.tissueGroup + " - ";
        if (this.tissueName.startsWith(frag)) {
            this.originalTissueName = this.tissueName;
            this.tissueName = this.tissueName.substring(frag.length());
            return true;
        }
        Matcher m = groupPattern.matcher(this.tissueName);
        if (m.matches()) {
            this.originalTissueName = this.tissueName;
            this.tissueName = m.group(2);
            this.tissueSecondaryGroup = m.group(1);
            return true;
        }
        return false;
    }

    public String getTissueSecondaryGroup() {
        return this.tissueSecondaryGroup;
    }

    public void setTissueSecondaryGroup(String tissueSecondaryGroup) {
        this.tissueSecondaryGroup = tissueSecondaryGroup;
    }

    private String getCompareString() {
        return this.tissueGroup + this.tissueName;
    }

    @Override
    public int compareTo(Sample o) {
        return this.getCompareString().compareTo(o.getCompareString());
    }

    public String getOriginalTissueName() {
        return this.originalTissueName;
    }

    public void setOriginalTissueName(String originalTissueName) {
        this.originalTissueName = originalTissueName;
    }
}

