/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.domain;

import java.util.Objects;
import org.geneweaver.domain.AbstractEntity;
import org.geneweaver.domain.Peak;
import org.geneweaver.domain.Track;
import org.neo4j.ogm.annotation.EndNode;
import org.neo4j.ogm.annotation.RelationshipEntity;
import org.neo4j.ogm.annotation.StartNode;

@RelationshipEntity(type="TRACKED")
public class Tracked
extends AbstractEntity {
    @StartNode
    private Track track;
    @EndNode
    private Peak peak;
    private String chr;

    public Tracked() {
    }

    public Tracked(Peak peak, Track track) {
        this.peak = peak;
        this.track = track;
        this.chr = peak.getChr();
    }

    public Track getTrack() {
        return this.track;
    }

    public void setTrack(Track track) {
        this.track = track;
    }

    public Peak getRegion() {
        return this.peak;
    }

    public void setRegion(Peak peak) {
        this.peak = peak;
    }

    @Override
    public String toString() {
        String tname = this.track != null ? this.track.getName() : null;
        String rname = this.peak != null ? this.peak.getName() : null;
        return tname + "-[TRACKED]->" + rname;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.chr, this.peak, this.track);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Tracked)) {
            return false;
        }
        Tracked other = (Tracked)obj;
        return Objects.equals(this.chr, other.chr) && Objects.equals(this.peak, other.peak) && Objects.equals(this.track, other.track);
    }

    @Override
    public String getChr() {
        return this.chr;
    }

    @Override
    public void setChr(String chr) {
        this.chr = chr;
    }
}

