/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.domain;

import java.util.Objects;
import org.geneweaver.domain.GeneticEntity;
import org.neo4j.ogm.annotation.Index;
import org.neo4j.ogm.annotation.NodeEntity;

@NodeEntity(label="Transcript")
public class Transcript
extends GeneticEntity {
    @Index(unique=true)
    private String transcriptId;
    private String transcriptName;
    private String geneName;
    private String geneVersion;
    private String geneBiotype;
    private String transcriptBiotype;

    public Transcript() {
    }

    public Transcript(String transcriptId, int start, int end) {
        this.transcriptId = transcriptId;
        this.setStart(start);
        this.setEnd(end);
    }

    @Override
    public String getHeader() {
        StringBuilder buf = new StringBuilder();
        buf.append("transcriptId:ID(Transcript-Id)");
        buf.append(this.getDelimiter());
        buf.append("transcriptName");
        buf.append(this.getDelimiter());
        buf.append("geneId");
        buf.append(this.getDelimiter());
        buf.append("geneName");
        buf.append(this.getDelimiter());
        buf.append("geneVersion");
        buf.append(this.getDelimiter());
        buf.append("geneBiotype");
        buf.append(this.getDelimiter());
        buf.append("transcriptBiotype");
        buf.append(this.getDelimiter());
        buf.append(super.getHeader());
        return buf.toString();
    }

    @Override
    public String toCsv() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getTranscriptId());
        buf.append(this.getDelimiter());
        buf.append(this.getTranscriptName());
        buf.append(this.getDelimiter());
        buf.append(this.getGeneId());
        buf.append(this.getDelimiter());
        buf.append(this.getGeneName());
        buf.append(this.getDelimiter());
        buf.append(this.getGeneVersion());
        buf.append(this.getDelimiter());
        buf.append(this.getGeneBiotype());
        buf.append(this.getDelimiter());
        buf.append(this.getTranscriptBiotype());
        buf.append(this.getDelimiter());
        buf.append(super.toCsv());
        return buf.toString();
    }

    public String getTranscriptId() {
        return this.transcriptId;
    }

    public void setTranscriptId(String transcript_id) {
        this.transcriptId = transcript_id;
    }

    public String getTranscriptName() {
        return this.transcriptName;
    }

    public void setTranscriptName(String transcript_name) {
        this.transcriptName = transcript_name;
    }

    public String getTranscriptBiotype() {
        return this.transcriptBiotype;
    }

    public void setTranscriptBiotype(String transcript_biotype) {
        this.transcriptBiotype = transcript_biotype;
    }

    public String getGeneName() {
        return this.geneName;
    }

    public void setGeneName(String gene_name) {
        this.geneName = gene_name;
    }

    public String getGeneBiotype() {
        return this.geneBiotype;
    }

    public void setGeneBiotype(String gene_biotype) {
        this.geneBiotype = gene_biotype;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.geneBiotype, this.geneName, this.geneVersion, this.transcriptBiotype, this.transcriptId, this.transcriptName);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Transcript)) {
            return false;
        }
        Transcript other = (Transcript)obj;
        return Objects.equals(this.geneBiotype, other.geneBiotype) && Objects.equals(this.geneName, other.geneName) && Objects.equals(this.geneVersion, other.geneVersion) && Objects.equals(this.transcriptBiotype, other.transcriptBiotype) && Objects.equals(this.transcriptId, other.transcriptId) && Objects.equals(this.transcriptName, other.transcriptName);
    }

    public String getGeneVersion() {
        return this.geneVersion;
    }

    public void setGeneVersion(String geneVersion) {
        this.geneVersion = geneVersion;
    }

    @Override
    public String id() {
        return this.getTranscriptId();
    }
}

