/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.domain;

import java.util.Objects;
import org.geneweaver.domain.AbstractEntity;
import org.geneweaver.domain.Located;
import org.neo4j.ogm.annotation.EndNode;
import org.neo4j.ogm.annotation.RelationshipEntity;
import org.neo4j.ogm.annotation.StartNode;

@RelationshipEntity(type="TRANSCRIPT_OVERLAP")
public class TranscriptOverlap
extends AbstractEntity {
    @StartNode
    private Located transcript;
    @EndNode
    private Located variant;

    @Override
    public String getHeader() {
        StringBuilder buf = new StringBuilder();
        buf.append(":START_ID(Transcript-Id)");
        buf.append(this.getDelimiter());
        buf.append(":END_ID(Rs-Id)");
        buf.append(this.getDelimiter());
        buf.append(":TYPE");
        return buf.toString();
    }

    @Override
    public String toCsv() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.transcript != null ? this.transcript.id() : "NA");
        buf.append(this.getDelimiter());
        buf.append(this.variant != null ? this.variant.id() : "NA");
        buf.append(this.getDelimiter());
        buf.append("TRANSCRIPT_OVERLAP");
        return buf.toString();
    }

    public Located getTranscript() {
        return this.transcript;
    }

    public void setTranscript(Located transcript) {
        this.transcript = transcript;
    }

    public Located getVariant() {
        return this.variant;
    }

    public void setVariant(Located variant) {
        this.variant = variant;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.transcript, this.variant);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof TranscriptOverlap)) {
            return false;
        }
        TranscriptOverlap other = (TranscriptOverlap)obj;
        return Objects.equals(this.transcript, other.transcript) && Objects.equals(this.variant, other.variant);
    }

    @Override
    public String toString() {
        if (this.transcript == null || this.variant == null) {
            return super.toString();
        }
        return "(Variant{rsId:" + this.variant.id() + "})-[TRANSCRIPT_OVERLAP]-(Transcript{transcriptId:" + this.transcript.id() + ")";
    }
}

