/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.domain;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.geneweaver.domain.GeneticEntity;
import org.geneweaver.domain.VariantEffect;
import org.neo4j.ogm.annotation.Index;
import org.neo4j.ogm.annotation.NodeEntity;

@NodeEntity(label="Variant")
public class Variant
extends GeneticEntity {
    @Index(unique=true)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String rsId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String dbxRef;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String id;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String refAllele;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String altAllele;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Float altAlleleFreq = Float.valueOf(0.0f);
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String biotype;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Set<VariantEffect> variantEffect;

    @Override
    public String getHeader() {
        StringBuilder buf = new StringBuilder();
        buf.append("rsId:ID(Rs-Id)");
        buf.append(this.getDelimiter());
        buf.append("id");
        buf.append(this.getDelimiter());
        buf.append("refAllele");
        buf.append(this.getDelimiter());
        buf.append("altAllele");
        buf.append(this.getDelimiter());
        buf.append("altAlleleFreq:float");
        buf.append(this.getDelimiter());
        buf.append("biotype");
        buf.append(this.getDelimiter());
        buf.append(super.getHeader());
        return buf.toString();
    }

    @Override
    public String toCsv() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getRsId());
        buf.append(this.getDelimiter());
        buf.append(this.getId());
        buf.append(this.getDelimiter());
        buf.append(this.getRefAllele());
        buf.append(this.getDelimiter());
        buf.append(this.getAltAllele());
        buf.append(this.getDelimiter());
        buf.append(this.getAltAlleleFreq());
        buf.append(this.getDelimiter());
        buf.append(this.getBiotype());
        buf.append(this.getDelimiter());
        buf.append(super.toCsv());
        return buf.toString();
    }

    public String getRsId() {
        return this.rsId;
    }

    public void setRsId(String rs_id) {
        this.rsId = rs_id;
    }

    public String getRefAllele() {
        return this.refAllele;
    }

    public void setRefAllele(String ref_allele) {
        this.refAllele = ref_allele;
    }

    public String getAltAllele() {
        return this.altAllele;
    }

    public void setAltAllele(String alt_allele) {
        this.altAllele = alt_allele;
    }

    public Float getAltAlleleFreq() {
        return this.altAlleleFreq;
    }

    public void setAltAlleleFreq(Float alt_allele_freq) {
        this.altAlleleFreq = alt_allele_freq;
    }

    public String getBiotype() {
        return this.biotype;
    }

    public void setBiotype(String biotype) {
        this.biotype = biotype;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.altAllele, this.altAlleleFreq, this.biotype, this.dbxRef, this.id, this.refAllele, this.rsId, this.variantEffect);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Variant)) {
            return false;
        }
        Variant other = (Variant)obj;
        return Objects.equals(this.altAllele, other.altAllele) && Objects.equals(this.altAlleleFreq, other.altAlleleFreq) && Objects.equals(this.biotype, other.biotype) && Objects.equals(this.dbxRef, other.dbxRef) && Objects.equals(this.id, other.id) && Objects.equals(this.refAllele, other.refAllele) && Objects.equals(this.rsId, other.rsId) && this.equalsNullEmpty(this.variantEffect, other.variantEffect);
    }

    private boolean equalsNullEmpty(Collection<?> c1, Collection<?> c2) {
        if (c1 == c2) {
            return true;
        }
        if (c1 == null && c2 == null) {
            return true;
        }
        if (c1 == null && c2.isEmpty()) {
            return true;
        }
        if (c1.isEmpty() && c2 == null) {
            return true;
        }
        return Objects.equals(c1, c2);
    }

    public Set<VariantEffect> getVariantEffect() {
        if (this.variantEffect == null) {
            return Collections.emptySet();
        }
        return this.variantEffect;
    }

    public void setVariantEffect(Set<VariantEffect> variantEffect) {
        this.variantEffect = variantEffect;
    }

    public void clearEffects() {
        if (this.getVariantEffect() != null) {
            this.getVariantEffect().clear();
        }
    }

    public String getDbxRef() {
        return this.dbxRef;
    }

    public void setDbxRef(String dbxRef) {
        this.dbxRef = dbxRef;
    }

    @Override
    public String id() {
        return this.getRsId();
    }

    @Override
    public String toString() {
        return "Variant [rsId=" + this.rsId + " start=" + this.getStart() + " end=" + this.getEnd() + " ]";
    }
}

