/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.domain;

import java.util.Objects;
import org.geneweaver.domain.AbstractEntity;
import org.geneweaver.domain.Transcript;
import org.geneweaver.domain.Variant;
import org.neo4j.ogm.annotation.EndNode;
import org.neo4j.ogm.annotation.RelationshipEntity;
import org.neo4j.ogm.annotation.StartNode;

@RelationshipEntity(type="VARIANT_EFFECT")
public class VariantEffect
extends AbstractEntity {
    @StartNode
    private Variant variant;
    @EndNode
    private Transcript transcript;
    private String sequenceVariant;
    private int index;
    private String featureType;
    private String featureId;

    @Override
    public String getHeader() {
        StringBuilder buf = new StringBuilder();
        buf.append(":START_ID(Rs-Id)");
        buf.append(this.getDelimiter());
        buf.append("sequenceVariant");
        buf.append(this.getDelimiter());
        buf.append("index:int");
        buf.append(this.getDelimiter());
        buf.append("featureType");
        buf.append(this.getDelimiter());
        buf.append("featureId");
        buf.append(this.getDelimiter());
        buf.append(":END_ID(Transcript-Id)");
        buf.append(this.getDelimiter());
        buf.append(":TYPE");
        return buf.toString();
    }

    @Override
    public String toCsv() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.variant.getRsId());
        buf.append(this.getDelimiter());
        buf.append(this.getSequenceVariant());
        buf.append(this.getDelimiter());
        buf.append(this.getIndex());
        buf.append(this.getDelimiter());
        buf.append(this.getFeatureType());
        buf.append(this.getDelimiter());
        buf.append(this.getFeatureId());
        buf.append(this.getDelimiter());
        buf.append(this.getFeatureId());
        buf.append(this.getDelimiter());
        buf.append("VARIANT_EFFECT");
        return buf.toString();
    }

    public String getSequenceVariant() {
        return this.sequenceVariant;
    }

    public void setSequenceVariant(String sequenceVariant) {
        this.sequenceVariant = sequenceVariant;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String getFeatureType() {
        return this.featureType;
    }

    public void setFeatureType(String featureType) {
        this.featureType = featureType;
    }

    public String getFeatureId() {
        return this.featureId;
    }

    public void setFeatureId(String featureId) {
        this.featureId = featureId;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.featureId, this.featureType, this.index, this.sequenceVariant);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof VariantEffect)) {
            return false;
        }
        VariantEffect other = (VariantEffect)obj;
        return Objects.equals(this.featureId, other.featureId) && Objects.equals(this.featureType, other.featureType) && this.index == other.index && Objects.equals(this.sequenceVariant, other.sequenceVariant);
    }

    public Variant getVariant() {
        return this.variant;
    }

    public void setVariant(Variant variant) {
        this.variant = variant;
    }

    public Transcript getTranscript() {
        return this.transcript;
    }

    public void setTranscript(Transcript transcript) {
        this.transcript = transcript;
    }

    @Override
    public String toString() {
        String rsId = this.variant != null ? this.variant.getRsId() : null;
        String transId = this.transcript != null ? this.transcript.getTranscriptId() : null;
        return rsId + "-[VARIANT_EFFECT]->" + transId;
    }
}

