/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.io;

import com.fasterxml.jackson.core.JsonParseException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.geneweaver.io.writer.JsonToCSVParser;

public class CLI {
    public static void main(String[] args) throws Exception {
        try {
            CommandLine cmd = CLI.parse(args);
            if (cmd == null) {
                return;
            }
            CLI.run(cmd, System.getenv());
        }
        finally {
            System.exit(0);
        }
    }

    private static void run(CommandLine cmd, Map<String, String> env) throws Exception {
        if (!CLI.checkEnv(env)) {
            return;
        }
        if (cmd.hasOption("convert")) {
            CLI.convert(cmd);
        }
    }

    private static void convert(CommandLine cmd) throws JsonParseException, IOException {
        Path json = Paths.get(cmd.getOptionValue('i'), new String[0]);
        if (!Files.exists(json, new LinkOption[0])) {
            throw new IllegalArgumentException("File does not exist: " + String.valueOf(json));
        }
        Path csv = Paths.get(cmd.getOptionValue('o'), new String[0]);
        String delim = cmd.getOptionValue('d', ",");
        if (delim.equals("TAB")) {
            delim = "\t";
        }
        JsonToCSVParser parser = new JsonToCSVParser();
        parser.setDelimiter(delim);
        parser.convert(json, csv);
    }

    private static boolean checkEnv(Map<String, String> env) {
        return true;
    }

    private static CommandLine parse(String[] args) throws ParseException {
        Options options = CLI.getOptions();
        DefaultParser parser = new DefaultParser();
        HelpFormatter formatter = new HelpFormatter();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            formatter.printHelp("Importer", options);
            throw e;
        }
        return cmd;
    }

    private static Options getOptions() {
        Options options = new Options();
        Option convert = new Option("convert", false, "Convert files switch. Use this to convert a json file created with Neo4j query to csv.");
        convert.setRequired(true);
        options.addOption(convert);
        Option input = new Option("i", "input", true, "The input file which we convert (e.g. json) .");
        input.setRequired(true);
        options.addOption(input);
        Option output = new Option("o", "output", true, "The output file which we write (e.g. for convert a csv table).");
        output.setRequired(true);
        options.addOption(output);
        Option delim = new Option("d", "delimiter", true, "The delimiter to use. Default is ',' and 'TAB' can be used for a tab character.");
        delim.setRequired(false);
        options.addOption(delim);
        return options;
    }

    public static void testRun(String ... args) throws Exception {
        CLI.testRun(args, System.getenv());
    }

    static void testRun(String[] args, Map<String, String> env) throws Exception {
        CommandLine cmd = CLI.parse(args);
        if (cmd == null) {
            throw new IOException("Invalid command line!");
        }
        CLI.run(cmd, env);
    }

    public static String get(String env, String prop, String def) {
        String venv = System.getenv(env);
        if (venv != null && !venv.trim().isEmpty()) {
            return venv;
        }
        return System.getProperty(prop, def);
    }
}

