/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.io;

import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class Configuration {
    private volatile ZipType zipType = ZipType.valueOf(System.getenv().getOrDefault("PARTITION_ZIP", "GZ"));
    private volatile int partitionLines = Integer.parseInt(System.getenv().getOrDefault("PARTITION_LINES", "10000"));
    private volatile long timeout = Integer.parseInt(System.getenv().getOrDefault("PARTITION_TIMEOUT", "30"));
    private volatile int permits = Integer.parseInt(System.getenv().getOrDefault("SIMULTANEOUS_UPLOAD_PERMITS", "10"));
    private volatile TimeUnit unit = TimeUnit.SECONDS;

    public static Configuration getDefault() {
        return new Configuration();
    }

    public long getTimeout() {
        return this.timeout;
    }

    public Configuration setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public Configuration setUnit(TimeUnit unit) {
        this.unit = unit;
        return this;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.partitionLines, this.timeout, this.unit, this.zipType});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Configuration)) {
            return false;
        }
        Configuration other = (Configuration)obj;
        return this.partitionLines == other.partitionLines && this.timeout == other.timeout && this.unit == other.unit && this.zipType == other.zipType;
    }

    public int getPartitionLines() {
        return this.partitionLines;
    }

    public Configuration setPartitionLines(int partitionLines) {
        this.partitionLines = partitionLines;
        return this;
    }

    public ZipType getZipType() {
        return this.zipType;
    }

    public Configuration setZipType(ZipType zipType) {
        this.zipType = zipType;
        return this;
    }

    public int getPermits() {
        return this.permits;
    }

    public void setPermits(int permits) {
        this.permits = permits;
    }

    public static enum ZipType {
        NONE("text/plain"),
        ZIP("application/zip"),
        GZ("application/gzip");

        private String ctype;

        private ZipType(String ctype) {
            this.ctype = ctype;
        }

        public String getContentType() {
            return this.ctype;
        }
    }

    public static enum FileType {
        GENE,
        VARIANT,
        UNKNOWN;

    }
}

