/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.geneweaver.domain.Entity;
import org.geneweaver.io.IPrintStream;
import org.geneweaver.io.Timer;

public class DirectSave
implements AutoCloseable {
    private IPrintStream log;
    private boolean verbose;

    public DirectSave() {
        this((IPrintStream)null, false);
    }

    public DirectSave(PrintStream log, boolean verbose) {
        this.log = IPrintStream.of(log);
        this.verbose = verbose;
    }

    public DirectSave(IPrintStream log, boolean verbose) {
        this.log = log;
        this.verbose = verbose;
    }

    public Entity save(Entity e, Map<Class<? extends Entity>, Map<String, Path>> paths, Map<Class<? extends Entity>, Map<String, BufferedWriter>> writers, Path dir, Timer timer) {
        return this.save(e, paths, writers, dir, timer, false);
    }

    public Entity save(Entity e, Map<Class<? extends Entity>, Map<String, Path>> paths, Map<Class<? extends Entity>, Map<String, BufferedWriter>> writers, Path dir, Timer timer, boolean append) {
        Class<?> clazz = e.getClass();
        synchronized (clazz) {
            try {
                String chr;
                if (!writers.containsKey(e.getClass())) {
                    Path hpath = dir.resolve(e.getClass().getSimpleName() + "-header.csv");
                    if (this.verbose && this.log != null) {
                        this.log.println("Creating header writer for " + String.valueOf(hpath));
                    }
                    BufferedWriter header = Files.newBufferedWriter(hpath, new OpenOption[0]);
                    header.write(e.getHeader());
                    header.newLine();
                    header.close();
                    writers.put(e.getClass(), Collections.synchronizedMap(new HashMap()));
                }
                Map<String, BufferedWriter> brs = writers.get(e.getClass());
                Map<String, Path> prs = paths.get(e.getClass());
                if (prs == null) {
                    prs = Collections.synchronizedMap(new HashMap());
                    paths.put(e.getClass(), prs);
                }
                if ((chr = e.getChr()) == null) {
                    chr = "NA";
                }
                if (!brs.containsKey(chr)) {
                    Path pbody = chr.equals("NO-CHROMOSOME") ? dir.resolve(e.getClass().getSimpleName() + ".csv.gz") : dir.resolve(e.getClass().getSimpleName() + "-chr" + chr + ".csv.gz");
                    if (this.verbose && this.log != null) {
                        this.log.println("Creating body writer for " + String.valueOf(pbody));
                    }
                    BufferedWriter body = DirectSave.createWriter(pbody, append);
                    brs.put(chr, body);
                    prs.put(chr, pbody);
                }
                BufferedWriter writer = writers.get(e.getClass()).get(chr);
                String csv = e.toCsv();
                writer.write(csv);
                writer.newLine();
                if (timer != null) {
                    Path path = paths.get(e.getClass()).get(chr);
                    timer.time(path.toString(), this.verbose);
                }
                return e;
            }
            catch (IOException ne) {
                throw new RuntimeException(ne);
            }
        }
    }

    public static BufferedWriter createWriter(File pbody, boolean append) throws FileNotFoundException, IOException {
        return DirectSave.createWriter(pbody.toPath(), append);
    }

    public static BufferedWriter createWriter(Path pbody, boolean append) throws FileNotFoundException, IOException {
        BufferedWriter body = new BufferedWriter(new OutputStreamWriter(new GZIPOutputStream(new FileOutputStream(pbody.toFile(), append))));
        return body;
    }

    @Override
    public void close() throws Exception {
    }
}

