/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.geneweaver.io.IPrintStream;

public class LogRedirector
implements IPrintStream {
    private int maxLines = Integer.getInteger("lines", 100000);
    private int removeAmount = Integer.getInteger("rinc", 1000);
    private int lineCount = 0;
    private PrintStream out;
    private boolean lineManagementActive = true;
    private Path output;

    public LogRedirector(PrintStream out) {
        this.out = out;
        this.lineManagementActive = false;
    }

    public LogRedirector(String path) {
        this(Paths.get(path, new String[0]));
    }

    public LogRedirector(Path path) {
        this.output = path;
        this.createPrintStream(path, true);
    }

    public LogRedirector(Path path, int max, int remove) {
        this.output = path;
        this.createPrintStream(path, true);
        this.maxLines = max;
        this.removeAmount = remove;
    }

    private void createPrintStream(Path path, boolean startNew) {
        try {
            OpenOption[] openOptionArray;
            if (startNew) {
                openOptionArray = new StandardOpenOption[]{};
            } else {
                StandardOpenOption[] standardOpenOptionArray = new StandardOpenOption[1];
                openOptionArray = standardOpenOptionArray;
                standardOpenOptionArray[0] = StandardOpenOption.APPEND;
            }
            OpenOption[] options = openOptionArray;
            OutputStream out = Files.newOutputStream(path, options);
            if (path.getFileName().toString().toLowerCase().endsWith(".gz")) {
                out = new GZIPOutputStream(out);
            }
            this.out = new PrintStream(out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkLineCount() {
        if (this.lineCount <= this.maxLines) {
            return;
        }
        try {
            this.out.close();
            List<String> lines = null;
            try (Closeable br = LogRedirector.createBufferedReader(this.output);){
                lines = ((BufferedReader)br).lines().skip(this.removeAmount).toList();
            }
            br = LogRedirector.createBufferedWriter(this.output);
            try {
                lines.stream().forEach(arg_0 -> LogRedirector.lambda$checkLineCount$0((BufferedWriter)br, arg_0));
            }
            finally {
                if (br != null) {
                    ((BufferedWriter)br).close();
                }
            }
        }
        catch (Exception ne) {
            ne.printStackTrace();
        }
        finally {
            this.createPrintStream(this.output, false);
        }
    }

    static BufferedReader createBufferedReader(Path path) throws IOException {
        InputStream in = Files.newInputStream(path, new OpenOption[0]);
        if (path.getFileName().toString().toLowerCase().endsWith(".gz")) {
            in = new GZIPInputStream(in);
        }
        return new BufferedReader(new InputStreamReader(in));
    }

    static BufferedWriter createBufferedWriter(Path path) throws IOException {
        OutputStream out = Files.newOutputStream(path, new OpenOption[0]);
        if (path.getFileName().toString().toLowerCase().endsWith(".gz")) {
            out = new GZIPOutputStream(out);
        }
        return new BufferedWriter(new OutputStreamWriter(out));
    }

    @Override
    public synchronized void println(String s) {
        this.out.println(s);
        if (!this.lineManagementActive) {
            return;
        }
        ++this.lineCount;
        this.checkLineCount();
    }

    @Override
    public PrintStream getPrintStream() {
        return this.out;
    }

    public int getMaxLines() {
        return this.maxLines;
    }

    public void setMaxLines(int maxLines) {
        this.maxLines = maxLines;
    }

    public int getRemoveAmount() {
        return this.removeAmount;
    }

    public void setRemoveAmount(int removeAmount) {
        this.removeAmount = removeAmount;
    }

    public Path getLog() {
        return this.output;
    }

    private static /* synthetic */ void lambda$checkLineCount$0(BufferedWriter br, String line) {
        try {
            br.write(line);
            br.newLine();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

