/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.geneweaver.io.Configuration;
import org.geneweaver.io.PartitionException;
import org.geneweaver.io.reader.Expander;

public class Partitioner {
    private final Path dir;
    private final Configuration conf;
    private Semaphore semaphore;
    private int partitionCount = 0;

    public Partitioner(File dir, Configuration conf) throws PartitionException, IOException {
        this(dir.toPath(), conf);
    }

    public Partitioner(Path dir, Configuration conf) throws PartitionException, IOException {
        if (!Files.exists(dir, new LinkOption[0])) {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            throw new PartitionException("The partition directory should be an empty existing dir " + String.valueOf(dir));
        }
        this.dir = dir;
        this.conf = conf;
        this.semaphore = new Semaphore(conf.getPermits());
    }

    public synchronized void partition(Path source, Consumer<Path> visitor) throws InterruptedException, PartitionException, IOException {
        this.partitionCount = 0;
        if (!Files.exists(source, new LinkOption[0])) {
            throw new NoSuchFileException("Cannot find file " + String.valueOf(source));
        }
        ExecutorService service = visitor != null ? Executors.newCachedThreadPool() : null;
        String fileName = source.getFileName().toString().toLowerCase();
        if (fileName.endsWith(".gz")) {
            this.gpartition(source, visitor, service);
        } else if (!fileName.endsWith(".zip")) {
            this.spartition(source, visitor, service);
        } else {
            try (Expander expander = new Expander();){
                List<Path> paths = expander.expand(source);
                ((Stream)paths.stream().parallel()).forEach(path -> this.spartition((Path)path, visitor, service));
                if (service != null) {
                    service.awaitTermination(this.conf.getTimeout(), this.conf.getUnit());
                }
            }
        }
        if (service != null) {
            service.shutdown();
            boolean done = service.awaitTermination(this.conf.getTimeout(), this.conf.getUnit());
            if (!done) {
                throw new PartitionException("Notification of parition visitors did not complete within timeout!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gpartition(Path sourcePath, Consumer<Path> visitor, ExecutorService service) throws PartitionException {
        Configuration.FileType fileType = this.getFileType(sourcePath);
        Path partition = null;
        Writer writer = null;
        try {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(sourcePath.toFile()))));){
                int pcount = 0;
                String nextLine = null;
                while ((nextLine = reader.readLine()) != null) {
                    if (this.partitionComplete(pcount, nextLine, fileType)) {
                        if (writer != null) {
                            this.visit((BufferedWriter)writer, partition, visitor, service);
                        }
                        partition = this.newPartition(this.dir, this.conf, sourcePath);
                        writer = Files.newBufferedWriter(partition, new OpenOption[0]);
                        pcount = 0;
                    }
                    writer.write(nextLine);
                    ((BufferedWriter)writer).newLine();
                    ++pcount;
                }
            }
            catch (Throwable throwable) {
                this.visit((BufferedWriter)writer, partition, visitor, service);
                throw throwable;
            }
            this.visit((BufferedWriter)writer, partition, visitor, service);
        }
        catch (IOException ne) {
            throw new PartitionException(ne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void spartition(Path sourcePath, Consumer<Path> visitor, ExecutorService service) throws PartitionException {
        Configuration.FileType fileType = this.getFileType(sourcePath);
        Path partition = null;
        Writer writer = null;
        try {
            try (Scanner scanner = new Scanner(sourcePath);){
                int pcount = 0;
                while (scanner.hasNextLine()) {
                    String nextLine = scanner.nextLine();
                    if (this.partitionComplete(pcount, nextLine, fileType)) {
                        if (writer != null) {
                            this.visit((BufferedWriter)writer, partition, visitor, service);
                        }
                        partition = this.newPartition(this.dir, this.conf, sourcePath);
                        writer = Files.newBufferedWriter(partition, new OpenOption[0]);
                        pcount = 0;
                    }
                    writer.write(nextLine);
                    ((BufferedWriter)writer).newLine();
                    ++pcount;
                }
            }
            finally {
                this.visit((BufferedWriter)writer, partition, visitor, service);
            }
        }
        catch (IOException ne) {
            throw new PartitionException(ne);
        }
    }

    private Configuration.FileType getFileType(Path source) throws PartitionException {
        Configuration.FileType type = Configuration.FileType.UNKNOWN;
        String fileName = source.getFileName().toString().toLowerCase();
        if (fileName.endsWith(".gtf") || fileName.endsWith(".gtf.zip") || fileName.endsWith(".gtf.gz")) {
            type = Configuration.FileType.GENE;
        } else if (fileName.endsWith(".gvf") || fileName.endsWith(".gvf.zip") || fileName.endsWith(".gvf.gz")) {
            type = Configuration.FileType.VARIANT;
        }
        if (type == Configuration.FileType.UNKNOWN) {
            throw new PartitionException("Cannot determine type of file to partition!");
        }
        return type;
    }

    private boolean partitionComplete(int pcount, String nextLine, Configuration.FileType ftype) {
        boolean newPartReq;
        if (pcount == 0) {
            return true;
        }
        boolean bl = newPartReq = pcount >= this.conf.getPartitionLines();
        if (newPartReq && ftype == Configuration.FileType.GENE) {
            String line = nextLine.trim();
            if (line.startsWith("#")) {
                return false;
            }
            String[] rec = line.split("\t");
            String type = rec[2];
            if (!"gene".equals(type.toLowerCase())) {
                return false;
            }
        }
        return newPartReq;
    }

    private final void visit(BufferedWriter writer, Path partition, Consumer<Path> visitor, ExecutorService service) throws IOException {
        try {
            this.semaphore.acquire();
            if (writer != null) {
                writer.flush();
                writer.close();
            }
            if (this.conf.getZipType() == Configuration.ZipType.ZIP) {
                Path zip = partition.getParent().resolve(String.valueOf(partition.getFileName()) + ".zip");
                try (FileInputStream in = new FileInputStream(partition.toFile());
                     ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zip.toFile()));){
                    out.putNextEntry(new ZipEntry(partition.getFileName().toString()));
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
                Files.delete(partition);
                partition = zip;
            } else if (this.conf.getZipType() == Configuration.ZipType.GZ) {
                Path gz = partition.getParent().resolve(String.valueOf(partition.getFileName()) + ".gz");
                try (FileInputStream in = new FileInputStream(partition.toFile());
                     GZIPOutputStream out = new GZIPOutputStream(new FileOutputStream(gz.toFile()));){
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
                Files.delete(partition);
                partition = gz;
            }
            if (service != null && visitor != null && Files.size(partition) > 0L) {
                Path part = partition;
                service.submit(() -> {
                    visitor.accept(part);
                    this.semaphore.release();
                });
            }
        }
        catch (InterruptedException i) {
            throw new PartitionException(i);
        }
    }

    private final Path newPartition(Path dir, Configuration conf, Path src) throws PartitionException {
        String fileName = src.getFileName().toString().toLowerCase();
        String baseName = FilenameUtils.getBaseName((String)fileName);
        String ext = FilenameUtils.getExtension((String)fileName);
        if (fileName.endsWith(".zip")) {
            throw new PartitionException("The source file when partitioning should not end in .zip!");
        }
        if (fileName.endsWith(".gz")) {
            ext = FilenameUtils.getExtension((String)baseName);
            baseName = FilenameUtils.getBaseName((String)baseName);
        }
        String partName = baseName + "_" + this.partitionCount + "." + ext;
        ++this.partitionCount;
        Path partition = dir.resolve(partName);
        if (Files.exists(partition, new LinkOption[0])) {
            throw new PartitionException("The file " + partName + " already exists in dir " + String.valueOf(dir) + ". Please ensure that the directory to create partitions is empty.");
        }
        return partition;
    }

    public Path getDir() {
        return this.dir;
    }

    public Configuration getConfiguration() {
        return this.conf;
    }
}

