/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.io;

public class TimeInfo
implements AutoCloseable {
    private long start;
    private long stop;
    private long count;
    private boolean fullCount;

    public TimeInfo() {
        this(false);
    }

    public TimeInfo(boolean fullCount) {
        this.fullCount = fullCount;
        this.start = System.currentTimeMillis();
        this.count = 0L;
        this.stop = Integer.MIN_VALUE;
    }

    public <T> T increment(T ignored) {
        this.increment();
        return ignored;
    }

    public long increment() {
        return ++this.count;
    }

    public void stop() {
        this.stop = System.currentTimeMillis();
    }

    @Override
    public void close() {
        this.stop();
    }

    public long getStart() {
        return this.start;
    }

    public TimeInfo setStart(long start) {
        this.start = start;
        return this;
    }

    public long getStop() {
        return this.stop;
    }

    public TimeInfo setStop(long stop) {
        this.stop = stop;
        return this;
    }

    public long getCount() {
        return this.count;
    }

    public TimeInfo setCount(long count) {
        this.count = count;
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.count ^ this.count >>> 32);
        result = 31 * result + (int)(this.start ^ this.start >>> 32);
        result = 31 * result + (int)(this.stop ^ this.stop >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeInfo other = (TimeInfo)obj;
        if (this.count != other.count) {
            return false;
        }
        if (this.start != other.start) {
            return false;
        }
        return this.stop == other.stop;
    }

    public long interval() {
        return this.stop - this.start;
    }

    public boolean isFullCount() {
        return this.fullCount;
    }

    public void setFullCount(boolean fullCount) {
        this.fullCount = fullCount;
    }
}

