/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.io;

import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.geneweaver.io.TimeInfo;

public class Timer {
    private volatile long inodes = 0L;
    private volatile long curT5;
    private volatile long start = System.currentTimeMillis();
    private long timedChunkSize = 10000L;
    private Consumer<String> consumer;

    public Timer() {
        this(System.out::println);
    }

    public Timer(Consumer<String> consumer) {
        this.consumer = consumer;
    }

    public void time() {
        this.time(null, false);
    }

    public void time(String message, boolean verbose) {
        ++this.inodes;
        if (this.inodes % this.timedChunkSize == 0L) {
            this.printTiming(message, verbose);
        }
    }

    public void time(TimeInfo info) {
        this.time(info.getCount());
    }

    private void time(long count) {
        this.inodes += count;
        long t5 = this.inodes / this.timedChunkSize;
        if (t5 > this.curT5) {
            if (count <= 0L) {
                return;
            }
            this.printTiming(null, false);
            this.curT5 = t5;
        }
    }

    private void printTiming(String extraMessage, boolean verbose) {
        long time = System.currentTimeMillis() - this.start;
        double tpn = (double)time / (double)this.inodes;
        if (verbose && extraMessage != null) {
            this.consumer.accept(extraMessage);
        }
        String threadName = Thread.currentThread().getName();
        String msg = String.format("Total %d in %d ms. Time per node %.4f ms (Thread %s)", this.inodes, time, tpn, threadName);
        this.consumer.accept(msg);
    }

    public void setTimedChunkSize(long chunkSize) {
        this.timedChunkSize = chunkSize;
    }

    public String getFormattedTime() {
        return this.getFormattedTime(System.currentTimeMillis());
    }

    public String getFormattedTime(long ltime) {
        if (ltime < this.start) {
            throw new IllegalArgumentException("The time must be > when we started to time!");
        }
        long millis = ltime - this.start;
        String time = String.format("%d:%d", TimeUnit.MILLISECONDS.toMinutes(millis), TimeUnit.MILLISECONDS.toSeconds(millis) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(millis)));
        return time;
    }
}

