/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.io.connector;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.geneweaver.io.reader.ReaderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDatabaseConnector {
    private static Logger logger = LoggerFactory.getLogger(AbstractDatabaseConnector.class);
    protected static final String driver = System.getProperty("gweaver.mappingdb.driver", "org.h2.Driver");
    protected String dabasePath;
    protected final String tableName;
    protected String databaseFileName;
    protected Map<Integer, File> source = new HashMap<Integer, File>();
    private boolean newDatabase = false;

    public AbstractDatabaseConnector(String tableName, String databaseFileName) {
        this.tableName = tableName;
        this.databaseFileName = databaseFileName;
    }

    public void add(int taxon, Path gtf) throws ClassNotFoundException, FileNotFoundException {
        this.add(taxon, gtf.toAbsolutePath().toFile());
    }

    public void add(int taxon, File gtf) throws ClassNotFoundException, FileNotFoundException {
        if (!gtf.exists()) {
            throw new FileNotFoundException(String.valueOf(gtf) + " is not there!");
        }
        if (this.dabasePath == null) {
            this.setLocation(gtf.getParentFile().toPath());
            Class.forName(driver);
        }
        this.source.put(taxon, gtf);
    }

    public void create() throws Exception {
        if (this.source.isEmpty()) {
            throw new IllegalArgumentException("The add() method must be called to add some data before creating the database!");
        }
        if (this.exists()) {
            if (this.isNewDatabase()) {
                Path db = Paths.get(this.dabasePath + ".mv.db", new String[0]);
                Files.delete(db);
            } else {
                logger.warn("The database " + this.dabasePath + " already exists and will not be recreated.");
                return;
            }
        }
        this.createDatabase();
        this.parseSource();
    }

    protected abstract void createDatabase() throws IOException, SQLException;

    protected abstract void parseSource() throws SQLException, ReaderException;

    protected Connection createConnection() throws SQLException {
        return this.createConnection(false);
    }

    protected Connection createConnection(boolean readOnly) throws SQLException {
        String uri = "jdbc:h2:" + this.dabasePath + ";mode=MySQL";
        if (readOnly) {
            uri = uri + ";ACCESS_MODE_DATA=r";
        }
        return DriverManager.getConnection(uri, "sa", "");
    }

    public boolean exists() {
        Path db = Paths.get(this.dabasePath + ".mv.db", new String[0]);
        return Files.exists(db, new LinkOption[0]);
    }

    public boolean isNewDatabase() {
        return this.newDatabase;
    }

    public void setNewDatabase(boolean newDatabase) {
        this.newDatabase = newDatabase;
    }

    /*
     * Exception decompiling
     */
    public int size() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setLocation(Path dir) {
        String path = dir.toAbsolutePath().toString();
        this.dabasePath = path + "/" + this.databaseFileName;
    }
}

