/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.io.connector;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.geneweaver.domain.AbstractEntity;
import org.geneweaver.domain.Entity;
import org.geneweaver.domain.Located;
import org.geneweaver.domain.Variant;
import org.geneweaver.io.IPrintStream;
import org.geneweaver.io.connector.ChromosomeService;
import org.geneweaver.io.connector.Connector;
import org.geneweaver.io.connector.IntersectionCreator;
import org.geneweaver.io.connector.OverlapService;
import org.geneweaver.io.reader.ReaderException;
import org.geneweaver.io.reader.ReaderFactory;
import org.geneweaver.io.reader.ReaderRequest;
import org.neo4j.ogm.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOverlapConnector<N extends Entity, E extends Entity>
implements Connector<N, E>,
AutoCloseable,
IntersectionCreator {
    protected static Logger logger = LoggerFactory.getLogger(AbstractOverlapConnector.class);
    private static ObjectMapper mapper = new ObjectMapper();
    private String tableName;
    private String fileName;
    protected OverlapService oservice = new OverlapService();
    protected ChromosomeService cservice = ChromosomeService.getInstance();
    protected String basePath;
    protected Collection<Path> source = new TreeSet<Path>();
    protected Map<String, Connection> connCache = Collections.synchronizedMap(new HashMap(23));
    protected Map<String, PreparedStatement> insertCache = Collections.synchronizedMap(new HashMap(1009));
    protected Map<String, PreparedStatement> selectCache = Collections.synchronizedMap(new HashMap(1009));
    protected List<String> fileFilters = new LinkedList<String>();
    protected volatile int count = 0;
    protected int frequency = 10000;
    protected boolean newestInDirectoryByName = false;
    protected TypeReference<HashMap<String, Object>> mapReference = new TypeReference<HashMap<String, Object>>(){};
    private Long limit;
    private Long skip;

    public void add(Path hFile) throws FileNotFoundException {
        if (!Files.exists(hFile, new LinkOption[0])) {
            throw new FileNotFoundException(hFile.toString());
        }
        this.source.add(hFile);
    }

    public Collection<Path> addAll(Path dir) throws IOException {
        return this.addAll(dir, -1);
    }

    Collection<Path> addAll(Path dir, int limit) throws IOException {
        Files.walk(dir, new FileVisitOption[0]).forEach(path -> {
            if (!Files.isRegularFile(path, new LinkOption[0])) {
                logger.debug(String.valueOf(path) + " is not a regular file and will not be used!");
                return;
            }
            boolean isOkay = this.fileFilters.isEmpty();
            for (String filter : this.fileFilters) {
                if (!path.getFileName().toString().toLowerCase().endsWith(filter)) continue;
                isOkay = true;
                break;
            }
            if (!isOkay) {
                return;
            }
            if (limit > 0 && this.source.size() > limit) {
                return;
            }
            if (this.isNewestInDirectoryByName()) {
                try {
                    ArrayList<Path> peers = new ArrayList<Path>(Files.list(path.getParent()).toList());
                    Collections.sort(peers);
                    Path last = (Path)peers.get(peers.size() - 1);
                    if (!Files.isSameFile(path, last)) {
                        return;
                    }
                }
                catch (IOException ne) {
                    logger.error("Cannot check for older ignored files in dir {}", (Object)path.getParent());
                }
            }
            this.source.add((Path)path);
        });
        return this.source;
    }

    public long create() throws SQLException, ReaderException, IOException {
        return this.create(null, IPrintStream.of(System.out));
    }

    public final <T extends Located> long create(String prefix, IPrintStream out) throws SQLException, ReaderException, IOException {
        if (this.source == null || this.source.isEmpty()) {
            throw new IllegalArgumentException();
        }
        int index = -1;
        long added = 0L;
        for (Path path : this.source) {
            ++index;
            if (out != null) {
                out.println("Input " + String.valueOf(path) + " " + index + " of " + this.source.size());
            }
            ReaderRequest request = new ReaderRequest(path.getFileName().toString(), path);
            this.configure(request);
            Object reader = ReaderFactory.getReader(request);
            Stream<Object> raw = reader.stream();
            if (this.skip != null && this.skip > 0L) {
                raw = raw.skip(this.skip);
            }
            Stream<Located> stream = raw.map(e -> this.coerce(e));
            stream = stream.filter((? super T l) -> this.filter((Located)l));
            stream = stream.filter(ChromosomeService::isValidChromosome).filter((? super T l) -> this.isValidClass(l));
            if (this.limit != null && this.limit > 0L) {
                stream = stream.limit(this.limit);
            }
            long stored = stream.map(loc -> this.store(loc, prefix, out)).filter((? super T s) -> s != null).count();
            added += stored;
        }
        return added;
    }

    @Override
    public Stream<E> stream(N ent, Session session, IPrintStream log) {
        if (!(ent instanceof Variant)) {
            return Stream.of(ent);
        }
        Variant variant = (Variant)ent;
        String shardName = this.oservice.getShardName(variant.getChr(), variant.getStart());
        LinkedList<Variant> ret = new LinkedList<Variant>();
        ret.add(variant);
        if (log != null && this.count % this.frequency == 0) {
            log.println("Using shard: " + shardName);
        }
        if (shardName != null) {
            try {
                PreparedStatement lookup = this.getSelectStatement(variant.getChr(), shardName, log);
                if (lookup == null) {
                    return ret.stream();
                }
                int a = Math.min(variant.getStart(), variant.getEnd());
                lookup.setInt(1, a);
                int b = Math.max(variant.getStart(), variant.getEnd());
                lookup.setInt(2, b);
                HashSet<String> usedIds = new HashSet<String>();
                try (ResultSet res = lookup.executeQuery();){
                    while (res.next()) {
                        String id = res.getString(1);
                        if (id == null) continue;
                        if (usedIds.contains(id)) {
                            logger.info("Encountered duplicate id (" + this.getClass().getSimpleName() + "): " + id);
                            continue;
                        }
                        if (!this.testId(id)) continue;
                        int rlow = res.getInt(2);
                        int rup = res.getInt(3);
                        String smeta = res.getString(4);
                        if (log != null && this.count % this.frequency == 0) {
                            log.println("Example of id (" + this.getClass().getSimpleName() + ") found: " + id);
                        }
                        Map meta = (Map)mapper.readValue(smeta, this.mapReference);
                        Object o = this.oservice.intersection(variant, this.createIntersectionObject(id, rlow, rup), this, meta);
                        if (o == null) continue;
                        ((AbstractEntity)o).setChr(variant.getChr());
                        ret.add((Variant)o);
                        usedIds.add(id);
                        if (log == null || this.count % this.frequency != 0) continue;
                        log.println("Example of overlap found: " + o.toCsv());
                    }
                }
            }
            catch (Exception ne) {
                logger.warn("Cannot map " + String.valueOf(variant), (Throwable)ne);
            }
        }
        ++this.count;
        return ret.stream();
    }

    protected abstract Located createIntersectionObject(String var1, int var2, int var3);

    protected boolean testId(String id) {
        return true;
    }

    protected boolean filter(Located loc) {
        return true;
    }

    protected void configure(ReaderRequest request) {
    }

    protected Located coerce(Object e) {
        return (Located)e;
    }

    protected boolean isValidClass(Object l) {
        return true;
    }

    protected <T extends Located> T store(T line, String prefix, IPrintStream out) {
        try {
            int lower = Math.min(line.getStart(), line.getEnd());
            int upper = Math.max(line.getStart(), line.getEnd());
            String chr = line.getChr();
            String lshardName = this.oservice.getShardName(chr, lower);
            if (lshardName == null) {
                String msg = "Could not find shard for " + chr;
                logger.warn(msg);
                out.println(msg);
                return null;
            }
            this.storeBase(lshardName, line, prefix, out);
            String ubshardName = this.oservice.getShardName(chr, upper);
            if (ubshardName == null) {
                String msg = "Could not find shard for " + chr;
                logger.warn(msg);
                out.println(msg);
                return null;
            }
            if (!ubshardName.equals(lshardName)) {
                this.storeBase(ubshardName, line, prefix, out);
            }
            return line;
        }
        catch (Exception ne) {
            out.println("Trying to process " + String.valueOf(line) + " failed: " + ne.getMessage());
            try {
                out.println(mapper.writerWithDefaultPrettyPrinter().writeValueAsString(line));
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
            }
            throw ne;
        }
    }

    private <T extends Located> void storeBase(String shardName, T line, String prefix, IPrintStream out) {
        if (shardName == null) {
            return;
        }
        try {
            PreparedStatement stmt = this.getInsertStatement(line.getChr(), shardName, out);
            if (stmt == null) {
                return;
            }
            String id = line.id();
            if (id == null) {
                return;
            }
            if (prefix != null && !id.startsWith(prefix)) {
                throw new IllegalArgumentException("The id '" + id + "' should have started with '" + prefix + "'");
            }
            stmt.setString(1, id);
            int lower = Math.min(line.getStart(), line.getEnd());
            stmt.setInt(2, lower);
            int upper = Math.max(line.getStart(), line.getEnd());
            stmt.setInt(3, upper);
            Map<String, Object> meta = this.getMeta(line);
            String smeta = mapper.writeValueAsString(meta);
            stmt.setString(4, smeta);
            stmt.execute();
        }
        catch (Exception ne) {
            ne.printStackTrace();
            throw new RuntimeException(ne);
        }
    }

    protected <T extends Located> Map<String, Object> getMeta(T line) {
        return Collections.emptyMap();
    }

    private PreparedStatement getInsertStatement(String chr, String shardName, IPrintStream out) throws Exception {
        Connection conn = this.getConnection(chr, false, out);
        if (conn == null) {
            return null;
        }
        PreparedStatement stmt = this.insertCache.get(shardName);
        if (stmt == null) {
            try (Statement create = conn.createStatement();){
                String sql = "CREATE TABLE IF NOT EXISTS " + this.tableName + shardName + " (id int NOT NULL AUTO_INCREMENT,  entityId VARCHAR(128) NOT NULL,  lower INTEGER, upper INTEGER, meta CHARACTER(1024));";
                create.executeUpdate(sql);
                logger.info("Create table if not exists " + shardName + ":" + this.tableName);
            }
            stmt = conn.prepareStatement("INSERT INTO " + this.tableName + shardName + " (entityId, lower, upper, meta) VALUES (?,?,?,?);");
            this.insertCache.put(shardName, stmt);
        }
        return stmt;
    }

    protected synchronized PreparedStatement getSelectStatement(String chr, String shardName, IPrintStream out) throws Exception {
        String name = Thread.currentThread().getName();
        String cacheKey = name + "/" + this.fileName + "/" + shardName;
        PreparedStatement stmt = this.selectCache.get(cacheKey);
        if (stmt != null) {
            return stmt;
        }
        Connection conn = this.getConnection(chr, true, out);
        if (conn == null) {
            return null;
        }
        if (stmt == null) {
            String sql = "SELECT entityId, lower, upper, meta FROM " + this.tableName + shardName + " WHERE (?<=upper AND lower<=?);";
            stmt = conn.prepareStatement(sql);
            this.selectCache.put(cacheKey, stmt);
        }
        return stmt;
    }

    protected Connection getConnection(String chr, boolean readOnly, IPrintStream out) throws Exception {
        String connKey = this.fileName + "/" + chr;
        Connection ret = this.connCache.get(connKey);
        if (ret == null && (ret = this.newConnection(chr, readOnly, out)) != null) {
            this.connCache.put(connKey, ret);
        }
        return ret;
    }

    private Connection newConnection(String chr, boolean readOnly, IPrintStream out) throws SQLException, IOException {
        if ((chr = this.cservice.getChromosome(chr)) == null) {
            return null;
        }
        String path = this.basePath + "_" + chr;
        if (out != null) {
            out.println("New database connection to file: " + path);
        }
        String uri = "jdbc:h2:" + path + ";mode=MySQL";
        if (readOnly) {
            uri = uri + ";ACCESS_MODE_DATA=r";
        }
        return DriverManager.getConnection(uri, "sa", "");
    }

    protected List<String> getFileFilters() {
        return this.fileFilters;
    }

    protected void setFileFilters(List<String> fileFilters) {
        this.fileFilters = fileFilters;
    }

    protected void setFileFilters(String ... fileFilters) {
        this.fileFilters = Arrays.asList(fileFilters);
    }

    public void setLocation(Path dir) {
        String path = dir.toAbsolutePath().toString();
        this.basePath = path + "/" + this.fileName;
    }

    public long size() throws Exception {
        Path dir = Paths.get(this.basePath, new String[0]).getParent();
        List files = Files.list(dir).filter((? super T x$0) -> Files.isRegularFile(x$0, new LinkOption[0])).filter((? super T p) -> p.getFileName().toString().toLowerCase().endsWith(".mv.db")).collect(Collectors.toList());
        long size = 0L;
        for (Path path : files) {
            Connection conn = this.createConnection(path);
            try {
                Statement tabs = conn.createStatement();
                try {
                    DatabaseMetaData md = conn.getMetaData();
                    ResultSet rs = md.getTables(null, null, "%", null);
                    ArrayList<String> names = new ArrayList<String>();
                    while (rs.next()) {
                        String tname = rs.getString(3);
                        if (!tname.startsWith(this.tableName)) continue;
                        names.add(tname);
                    }
                    for (String tname : names) {
                        Statement stmt = conn.createStatement();
                        try {
                            String sql = "SELECT COUNT(1) FROM " + tname + ";";
                            ResultSet res = stmt.executeQuery(sql);
                            try {
                                res.next();
                                size += res.getLong(1);
                            }
                            finally {
                                if (res == null) continue;
                                res.close();
                            }
                        }
                        finally {
                            if (stmt == null) continue;
                            stmt.close();
                        }
                    }
                }
                finally {
                    if (tabs == null) continue;
                    tabs.close();
                }
            }
            finally {
                if (conn == null) continue;
                conn.close();
            }
        }
        return size;
    }

    private Connection createConnection(Path path) throws SQLException {
        String spath = path.toString().substring(0, path.toString().toLowerCase().lastIndexOf(".mv.db"));
        String uri = "jdbc:h2:" + spath + ";mode=MySQL;ACCESS_MODE_DATA=r";
        return DriverManager.getConnection(uri, "sa", "");
    }

    @Override
    public void close() throws SQLException {
        for (String string : this.insertCache.keySet()) {
            Statement stmt = this.insertCache.get(string);
            stmt.close();
        }
        this.insertCache.clear();
        for (Statement statement : this.selectCache.values()) {
            statement.close();
        }
        this.selectCache.clear();
        for (Connection connection : this.connCache.values()) {
            connection.close();
        }
        this.connCache.clear();
    }

    public Long getLimit() {
        return this.limit;
    }

    public void setLimit(Long limit) {
        this.limit = limit;
    }

    public Long getSkip() {
        return this.skip;
    }

    public void setSkip(Long skip) {
        this.skip = skip;
    }

    protected String getFileName() {
        return this.fileName;
    }

    protected void setFileName(String fileName) {
        this.fileName = fileName;
    }

    protected String getTableName() {
        return this.tableName;
    }

    protected void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public void setFrequency(int frequency) {
        this.frequency = frequency;
    }

    public boolean isNewestInDirectoryByName() {
        return this.newestInDirectoryByName;
    }

    public void setNewestInDirectoryByName(boolean newestInDirectoryByName) {
        this.newestInDirectoryByName = newestInDirectoryByName;
    }
}

