/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.io.connector;

import java.util.function.Function;
import java.util.stream.Stream;
import org.geneweaver.domain.Entity;
import org.geneweaver.domain.NamedEntity;
import org.geneweaver.domain.Peak;
import org.geneweaver.domain.Track;
import org.geneweaver.domain.Tracked;
import org.geneweaver.io.IPrintStream;
import org.geneweaver.io.connector.Connector;
import org.geneweaver.io.connector.ConnectorException;
import org.neo4j.ogm.session.Session;

public class BedConnector<N extends NamedEntity, E extends Entity>
implements Connector<N, E>,
Function<N, Stream<E>> {
    private Track currentTrack;

    @Override
    public Stream<E> stream(N bean, Session session, IPrintStream log) {
        return this.apply(bean);
    }

    @Override
    public Stream<E> apply(N bean) {
        String name = ((NamedEntity)bean).getName();
        if (bean instanceof Track && (name == null || name.isEmpty())) {
            throw new ConnectorException("Tracks must have a name!");
        }
        if (bean instanceof Track) {
            this.currentTrack = (Track)bean;
            return Stream.of(bean);
        }
        if (bean instanceof Peak) {
            if (this.currentTrack != null) {
                return Stream.of(bean, new Tracked((Peak)bean, this.currentTrack));
            }
            return Stream.of(bean);
        }
        throw new ConnectorException(this.getClass().getSimpleName() + " may not be used with " + bean.getClass().getSimpleName());
    }
}

