/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.io.connector;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geneweaver.domain.Located;

public class ChromosomeService {
    public static final String na = "NA";
    private static final String chromo = "(chr)?([0-9]{0,2}|x|y|m|(mt)|na)";
    private static final Pattern strictChromPattern = Pattern.compile("^((chr)?([0-9]{0,2}|x|y|m|(mt)|na))$");
    private static final Pattern chromPattern = Pattern.compile("^((chr)?([0-9]{0,2}|x|y|m|(mt)|na)|(chr)?([0-9]{0,2}|x|y|m|(mt)|na)_.*)$");
    private static final Map<String, String> chrCache = new HashMap<String, String>();
    private static ChromosomeService staticInstance;

    public static ChromosomeService getInstance() {
        if (staticInstance == null) {
            staticInstance = new ChromosomeService();
        }
        return staticInstance;
    }

    private ChromosomeService() {
    }

    public String getChromosome(String chr) {
        if (chr == null) {
            return null;
        }
        if (chrCache.containsKey(chr)) {
            return chrCache.get(chr);
        }
        if (chr.isBlank()) {
            return null;
        }
        chr = chr.toLowerCase();
        if (Boolean.getBoolean("strict")) {
            String lchr;
            Matcher matcher = strictChromPattern.matcher(chr);
            if (matcher.matches() && (lchr = matcher.group(3)) != null && !lchr.isBlank()) {
                if ("mt".equals(lchr)) {
                    lchr = "m";
                }
                lchr = lchr.toUpperCase();
                chrCache.put(chr, lchr);
                return lchr;
            }
            chrCache.put(chr, null);
            return null;
        }
        Matcher matcher = chromPattern.matcher(chr);
        if (matcher.matches()) {
            String lchr = matcher.group(3);
            if (lchr == null || lchr.isBlank()) {
                lchr = matcher.group(6);
            }
            if (lchr == null || lchr.isBlank()) {
                chrCache.put(chr, null);
                return null;
            }
            int upos = lchr.indexOf(95);
            if (upos > 0) {
                lchr = lchr.substring(0, upos);
            }
            if ("mt".equals(lchr)) {
                lchr = "m";
            }
            lchr = lchr.toUpperCase();
            chrCache.put(chr, lchr);
            return lchr;
        }
        chrCache.put(chr, null);
        return null;
    }

    public static boolean isValidChromosome(Located entity) {
        String chr = entity.getChr();
        return chr != null;
    }

    public static void clearCache() {
        chrCache.clear();
    }
}

