/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.io.connector;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

public class CloseableCache<K, V extends AutoCloseable>
implements Map<K, V> {
    private int max;
    private Map<K, V> map;

    public CloseableCache(int max) {
        this.max = max;
        this.map = new LinkedHashMap(max);
    }

    @Override
    public V put(K key, V value) {
        AutoCloseable v = (AutoCloseable)this.map.put(key, value);
        if (this.map.size() > this.max) {
            K oldestKey = this.map.keySet().iterator().next();
            AutoCloseable old = (AutoCloseable)this.map.remove(oldestKey);
            try {
                old.close();
            }
            catch (Exception ne) {
                throw new RuntimeException(ne);
            }
        }
        return (V)v;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return (V)((AutoCloseable)this.map.get(key));
    }

    @Override
    public V remove(Object key) {
        return (V)((AutoCloseable)this.map.remove(key));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.map.putAll(m);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.map.equals(o);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        return (V)((AutoCloseable)this.map.getOrDefault(key, defaultValue));
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.map.forEach(action);
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        this.map.replaceAll(function);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return (V)((AutoCloseable)this.map.putIfAbsent(key, value));
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.map.remove(key, value);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.map.replace(key, oldValue, newValue);
    }

    @Override
    public V replace(K key, V value) {
        return (V)((AutoCloseable)this.map.replace(key, value));
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return (V)((AutoCloseable)this.map.computeIfAbsent((K)key, mappingFunction));
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return (V)((AutoCloseable)this.map.computeIfPresent((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction));
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return (V)((AutoCloseable)this.map.compute((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction));
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return (V)((AutoCloseable)this.map.merge(key, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction));
    }
}

