/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.io.connector;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.io.FilenameUtils;
import org.geneweaver.domain.EQTL;
import org.geneweaver.domain.EQTLBase;
import org.geneweaver.domain.Sample;
import org.geneweaver.io.connector.TissueKey;
import org.geneweaver.io.reader.ReaderFactory;
import org.geneweaver.io.reader.ReaderRequest;
import org.geneweaver.io.reader.StreamUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EQTLFunction<N extends EQTL, E extends EQTL>
implements Function<N, E>,
AutoCloseable {
    private static Logger logger = LoggerFactory.getLogger(EQTLFunction.class);
    private static final String driver = System.getProperty("gweaver.gtex.mappingdb.driver", "org.h2.Driver");
    private static final String tableName = System.getProperty("gweaver.gtex.mappingdb.tableName", "IDMAPPING");
    private Serializable mapping;
    private Serializable attributes;
    private String split = System.getProperty("gweaver.gtex.mappingdb.lookupDelimiter", "\\t+");
    private String dabasePath;
    private Connection connection;
    private PreparedStatement lookup;
    private Map<TissueKey, Sample> roughMap;

    public EQTLFunction(Path path, Path attributes) throws ClassNotFoundException {
        this(path.toAbsolutePath().toFile(), attributes.toAbsolutePath().toFile());
    }

    public EQTLFunction(File mapping, File attributes) throws ClassNotFoundException {
        this.mapping = mapping.getAbsoluteFile();
        this.attributes = attributes.getAbsoluteFile();
        this.setLocation(mapping.getParentFile().toPath());
        Class.forName(driver);
    }

    public EQTLFunction(URL mapping, URL attributes) throws ClassNotFoundException {
        this.mapping = mapping;
        this.setLocation(Paths.get(".", new String[0]));
        Class.forName(driver);
    }

    public void setLocation(Path dir) {
        String path = dir.toAbsolutePath().toString();
        this.dabasePath = path + "/" + FilenameUtils.getName((String)this.mapping.toString()) + ".h2";
    }

    @Override
    public E apply(N t) {
        Sample sample;
        if (((EQTL)t).getRsId() != null) {
            return (E)t;
        }
        if (this.connection == null) {
            try {
                this.connection = this.createConnection();
            }
            catch (SQLException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        String variantId = ((EQTL)t).getEqtlVariantId();
        try {
            if (this.lookup == null) {
                this.lookup = this.connection.prepareStatement("SELECT rsId FROM " + tableName + " WHERE variantId = ?;");
            }
            this.lookup.setString(1, variantId);
            try (ResultSet res = this.lookup.executeQuery();){
                res.next();
                String rsId = res.getString(1);
                ((EQTL)t).setRsId(rsId);
            }
        }
        catch (SQLException ne) {
            throw new RuntimeException("Cannot map " + variantId, ne);
        }
        if (this.roughMap == null) {
            try {
                this.roughMap = new HashMap<TissueKey, Sample>();
                Object samples = ReaderFactory.getReader(new ReaderRequest(this.stream(this.attributes), this.name(this.attributes)));
                samples.stream().forEach(s -> this.roughMap.put(new TissueKey((Sample)s), (Sample)s));
            }
            catch (Exception ne) {
                logger.error("Cannot parse sample attributes!", (Throwable)ne);
            }
        }
        if ((sample = this.roughMap.get(new TissueKey(((EQTLBase)t).getTissueName()))) == null && ((EQTLBase)t).getTissueName() != null) {
            throw new RuntimeException("Cannot find sample for " + ((EQTLBase)t).getTissueName());
        }
        if (sample != null) {
            ((EQTLBase)t).setTissueGroup(sample.getTissueGroup());
            ((EQTLBase)t).setTissueName(sample.getOriginalTissueName());
        }
        return (E)t;
    }

    @Override
    public void close() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
        }
        if (this.lookup != null) {
            this.lookup.close();
        }
    }

    public void create() throws IOException, SQLException {
        if (this.exists()) {
            logger.info("The database " + this.dabasePath + " already exists and will not be recreated.");
            return;
        }
        this.createMappingDatabase();
        this.parseMappingFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseMappingFile() throws SQLException, IOException {
        try (Connection conn = this.createConnection();
             PreparedStatement stmt = conn.prepareStatement("INSERT INTO " + tableName + " (variantId, rsId) VALUES (?,?);");){
            Iterator<String> iterator = StreamUtil.createStream(this.stream(this.mapping), this.name(this.mapping), true);
            try {
                int varIndex = -1;
                int rsIndex = -1;
                while (iterator.hasNext()) {
                    String line = iterator.next();
                    String[] frags = line.split(this.getSplit());
                    if (varIndex < 0 || rsIndex < 0) {
                        for (int i = 0; i < frags.length; ++i) {
                            if ("variant_id".equals(frags[i].toLowerCase())) {
                                varIndex = i;
                                continue;
                            }
                            if (!frags[i].toLowerCase().startsWith("rs_id_")) continue;
                            rsIndex = i;
                        }
                        continue;
                    }
                    stmt.setString(1, frags[varIndex]);
                    stmt.setString(2, frags[rsIndex]);
                    stmt.execute();
                }
            }
            finally {
                if (iterator instanceof Closeable) {
                    ((Closeable)((Object)iterator)).close();
                }
            }
        }
    }

    private void createMappingDatabase() throws IOException, SQLException {
        try (Connection conn = this.createConnection();
             Statement stmt = conn.createStatement();){
            String sql = "CREATE TABLE " + tableName + " (id int NOT NULL AUTO_INCREMENT,  variantId VARCHAR(512) NOT NULL UNIQUE,  rsId VARCHAR(32));";
            stmt.executeUpdate(sql);
            logger.info("Created table IDMAPPING");
        }
    }

    private Connection createConnection() throws SQLException {
        return DriverManager.getConnection("jdbc:h2:" + this.dabasePath, "sa", "");
    }

    @JsonIgnore
    InputStream stream(Serializable ser) throws IOException {
        if (ser == null) {
            return null;
        }
        if (ser instanceof File) {
            return new FileInputStream((File)ser);
        }
        if (ser instanceof URL) {
            return ((URL)ser).openStream();
        }
        return null;
    }

    @JsonIgnore
    String name(Serializable ser) throws IOException {
        if (this.mapping == null) {
            return null;
        }
        return FilenameUtils.getName((String)ser.toString());
    }

    public String getSplit() {
        return this.split;
    }

    public void setSplit(String split) {
        this.split = split;
    }

    public boolean exists() {
        Path db = Paths.get(this.dabasePath + ".mv.db", new String[0]);
        return Files.exists(db, new LinkOption[0]);
    }

    /*
     * Exception decompiling
     */
    public int size() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Serializable getMapping() {
        return this.mapping;
    }
}

