/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.io.connector;

import java.util.HashMap;
import java.util.Map;
import org.geneweaver.domain.AbstractEntity;
import org.geneweaver.domain.EQTL;
import org.geneweaver.domain.EQTLOverlap;
import org.geneweaver.domain.Entity;
import org.geneweaver.domain.Gene;
import org.geneweaver.domain.Located;
import org.geneweaver.domain.Variant;
import org.geneweaver.io.connector.AbstractOverlapConnector;

public class EQTLOverlapConnector<N extends Entity, E extends Entity>
extends AbstractOverlapConnector<N, E> {
    public EQTLOverlapConnector() {
        this("eqtloverlaps");
    }

    public EQTLOverlapConnector(String databaseFileName) {
        this.setTableName(System.getProperty("gweaver.mappingdb.tableName", "REGIONS"));
        this.setFileName(databaseFileName);
        this.setFileFilters(".csv.gz", ".csv");
    }

    @Override
    protected Located createIntersectionObject(String id, int start, int end) {
        return new Gene(id, start, end);
    }

    @Override
    protected <T extends Located> Map<String, Object> getMeta(T line) {
        EQTL eqtl = (EQTL)line;
        HashMap<String, Object> meta = new HashMap<String, Object>();
        meta.put("chr", eqtl.getChrGRCm39());
        meta.put("bp", eqtl.getBpGRCm39());
        meta.put("lod", eqtl.getLod());
        meta.put("tissueFileName", eqtl.getTissueFileName());
        meta.put("tissueGroup", eqtl.getTissueGroup());
        meta.put("tissueName", eqtl.getTissueName());
        meta.put("uberon", eqtl.getUberon());
        meta.put("studyId", eqtl.getStudyId());
        return meta;
    }

    @Override
    protected boolean filter(Located loc) {
        return loc instanceof EQTL;
    }

    @Override
    public <T extends AbstractEntity> T create(Located loc, Variant variant) {
        if (loc instanceof Gene) {
            EQTLOverlap ret = new EQTLOverlap();
            ret.setGene(loc);
            ret.setVariant(variant);
            return (T)ret;
        }
        throw new IllegalArgumentException("Cannot intersect with " + String.valueOf(loc));
    }
}

