/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.io.connector;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Stream;
import org.geneweaver.domain.Entity;
import org.geneweaver.domain.Gene;
import org.geneweaver.domain.GeneticEntity;
import org.geneweaver.domain.Produces;
import org.geneweaver.domain.Transcript;
import org.geneweaver.io.IPrintStream;
import org.geneweaver.io.connector.Connector;
import org.geneweaver.io.connector.ConnectorException;
import org.neo4j.ogm.session.Session;

public class GeneConnector<N extends GeneticEntity, E extends Entity>
implements Connector<N, E>,
Function<N, Stream<E>> {
    private Cache<String, Gene> recentGenes = this.createCache();

    @Override
    public Stream<E> apply(GeneticEntity bean) {
        String geneId = bean.getGeneId();
        if (geneId == null || geneId.isEmpty()) {
            throw new ConnectorException("Genes and Transcripts must have a geneId!");
        }
        if (bean instanceof Gene) {
            if (this.recentGenes.getIfPresent((Object)geneId) != null) {
                throw new ConnectorException("The gene id " + geneId + " appears twice!");
            }
            Gene gene = (Gene)bean;
            this.recentGenes.put((Object)geneId, (Object)gene);
            return Stream.of(gene);
        }
        if (bean instanceof Transcript) {
            Gene gene = (Gene)this.recentGenes.getIfPresent((Object)geneId);
            Transcript transcript = (Transcript)bean;
            if (gene == null) {
                throw new ConnectorException("The gene id " + geneId + " for Transcript '" + transcript.getTranscriptId() + " has not been found!");
            }
            Produces produces = new Produces(gene, transcript);
            produces.setChr(transcript.getChr());
            return Stream.of(transcript, produces);
        }
        throw new ConnectorException(this.getClass().getSimpleName() + " may not be used with " + bean.getClass().getSimpleName());
    }

    @Override
    public Stream<E> stream(GeneticEntity bean, Session session, IPrintStream log) {
        return this.apply(bean);
    }

    private <T> Cache<String, T> createCache() {
        return CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(2L, TimeUnit.MINUTES).build();
    }
}

