/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.io.connector;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Stream;
import org.geneweaver.domain.AbstractEntity;
import org.geneweaver.domain.Entity;
import org.geneweaver.domain.Homolog;
import org.geneweaver.domain.HomologGene;
import org.geneweaver.io.IPrintStream;
import org.geneweaver.io.connector.Connector;
import org.neo4j.ogm.session.Session;

public class HomologConnector<N extends Entity, E extends Entity>
implements Connector<N, E>,
Function<N, Stream<E>> {
    private Cache<Long, Collection<HomologGene>> mouseCache = this.createCache();

    @Override
    public Stream<E> stream(N entity, Session unused, IPrintStream log) {
        HomologGene hgene = (HomologGene)entity;
        if (hgene.getOrganismName().toLowerCase().startsWith("mouse")) {
            LinkedList<HomologGene> mhols = (LinkedList<HomologGene>)this.mouseCache.getIfPresent((Object)hgene.getHid());
            if (mhols == null) {
                mhols = new LinkedList<HomologGene>();
                this.mouseCache.put((Object)hgene.getHid(), mhols);
            }
            mhols.add(hgene);
            return Stream.of(hgene);
        }
        Long hid = hgene.getHid();
        Collection mouse = (Collection)this.mouseCache.getIfPresent((Object)hid);
        if (mouse != null) {
            LinkedList<AbstractEntity> ret = new LinkedList<AbstractEntity>();
            for (HomologGene hg : mouse) {
                Homolog hom = new Homolog(hg.getHid(), hg.getGeneId(), hgene.getGeneId());
                hom.setSource(hgene.getSource());
                ret.add(hom);
            }
            ret.add(hgene);
            return ret.stream();
        }
        return Stream.of(hgene);
    }

    private <T> Cache<Long, T> createCache() {
        return CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.MINUTES).build();
    }

    @Override
    public Stream<E> apply(N t) {
        return this.stream(t);
    }
}

