/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.io.connector;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.function.Function;
import org.geneweaver.domain.Entity;
import org.geneweaver.domain.Gene;
import org.geneweaver.domain.HomologGene;
import org.geneweaver.io.connector.AbstractDatabaseConnector;
import org.geneweaver.io.reader.ReaderException;
import org.geneweaver.io.reader.ReaderFactory;
import org.geneweaver.io.reader.ReaderRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HomologFunction<N extends HomologGene, E extends HomologGene>
extends AbstractDatabaseConnector
implements Function<N, E>,
AutoCloseable {
    private static Logger logger = LoggerFactory.getLogger(HomologFunction.class);
    private Connection connection;
    private PreparedStatement lookup;

    public HomologFunction() {
        this("homologene.h2");
    }

    public HomologFunction(String databaseFileName) {
        super(System.getProperty("gweaver.mappingdb.tableName", "IDMAPPING"), databaseFileName);
    }

    @Override
    public E apply(N t) {
        if (((HomologGene)t).getGeneId() != null) {
            return (E)t;
        }
        if (this.connection == null) {
            try {
                this.connection = this.createConnection();
            }
            catch (SQLException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        String geneNameKey = ((HomologGene)t).getGeneNameKey().toLowerCase();
        try {
            if (this.lookup == null) {
                this.lookup = this.connection.prepareStatement("SELECT geneId FROM " + this.tableName + " WHERE geneNameKey = ?;");
            }
            this.lookup.setString(1, geneNameKey);
            try (ResultSet res = this.lookup.executeQuery();){
                res.next();
                String geneId = res.getString(1);
                ((HomologGene)t).setGeneId(geneId);
            }
        }
        catch (SQLException ne) {
            logger.warn("Cannot map " + geneNameKey, (Throwable)ne);
            return (E)t;
        }
        return (E)t;
    }

    @Override
    public void close() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
        }
        if (this.lookup != null) {
            this.lookup.close();
        }
    }

    @Override
    protected void parseSource() throws SQLException, ReaderException {
        try (Connection conn = this.createConnection();
             PreparedStatement stmt = conn.prepareStatement("INSERT INTO " + this.tableName + " (geneNameKey, geneId) VALUES (?,?) ON DUPLICATE KEY UPDATE id=id;");){
            for (Integer taxon : this.source.keySet()) {
                File file = (File)this.source.get(taxon);
                Object reader = ReaderFactory.getReader(new ReaderRequest(String.valueOf(taxon), file));
                reader.stream().filter(g -> g instanceof Gene).forEach(ge -> this.storeGene((Entity)ge, stmt, taxon));
            }
        }
    }

    private void storeGene(Entity ge, PreparedStatement stmt, int taxon) {
        try {
            Gene gene = (Gene)ge;
            if (gene.getGeneName() == null) {
                return;
            }
            String lcName = gene.getGeneName().toLowerCase();
            stmt.setString(1, taxon + ":" + lcName);
            stmt.setString(2, gene.getGeneId());
            stmt.execute();
            if (lcName.contains(".")) {
                String notDot = lcName.substring(0, lcName.lastIndexOf(46));
                stmt.setString(1, taxon + ":" + notDot);
                stmt.setString(2, gene.getGeneId());
                stmt.execute();
            }
        }
        catch (Exception ne) {
            ne.printStackTrace();
            throw new RuntimeException(ne);
        }
    }

    @Override
    protected void createDatabase() throws IOException, SQLException {
        try (Connection conn = this.createConnection();
             Statement stmt = conn.createStatement();){
            String sql = "CREATE TABLE IF NOT EXISTS " + this.tableName + " (id int NOT NULL AUTO_INCREMENT,  geneNameKey VARCHAR(64) NOT NULL UNIQUE,  geneId VARCHAR(64));";
            stmt.executeUpdate(sql);
            logger.info("Created table " + this.tableName);
        }
    }
}

