/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.io.connector;

import java.util.Map;
import org.apache.commons.beanutils.BeanMap;
import org.geneweaver.domain.AbstractEntity;
import org.geneweaver.domain.Located;
import org.geneweaver.domain.Variant;
import org.geneweaver.io.CLI;
import org.geneweaver.io.connector.ChromosomeService;
import org.geneweaver.io.connector.IntersectionCreator;

public class OverlapService {
    private ChromosomeService cservice = ChromosomeService.getInstance();
    private static final int baseSize = Integer.parseInt(System.getenv().getOrDefault("BASE_SIZE", "100000"));
    static int minOverlap;

    public <T extends AbstractEntity> T intersection(Variant variant, Located loc, IntersectionCreator creator, Map<String, Object> meta) {
        boolean intersects;
        int vs = Math.min(variant.getStart(), variant.getEnd());
        int ve = Math.max(variant.getStart(), variant.getEnd());
        int ps = Math.min(loc.getStart(), loc.getEnd());
        int pe = Math.max(loc.getStart(), loc.getEnd());
        boolean bl = intersects = vs <= pe && ps <= ve;
        if (!intersects) {
            return null;
        }
        Object relationship = creator.create(loc, variant);
        BeanMap map = new BeanMap(relationship);
        map.putAll(meta);
        return relationship;
    }

    public int getShardBase(int loc) {
        return Math.round(loc / baseSize);
    }

    public String getShardName(String chr, int loc) {
        StringBuilder b = new StringBuilder();
        String chrGood = this.cservice.getChromosome(chr);
        if (chrGood == null) {
            return null;
        }
        b.append("_");
        b.append(chrGood);
        b.append("_");
        b.append(this.getShardBase(loc));
        return b.toString();
    }

    static {
        String smin = CLI.get("MIN_OVERLAP", "min.overlap", "1");
        minOverlap = Integer.parseInt(smin);
    }
}

