/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.io.connector;

import java.io.IOException;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geneweaver.domain.AbstractEntity;
import org.geneweaver.domain.Entity;
import org.geneweaver.domain.Located;
import org.geneweaver.domain.Peak;
import org.geneweaver.domain.PeakOverlap;
import org.geneweaver.domain.Variant;
import org.geneweaver.io.connector.AbstractOverlapConnector;

public class PeakOverlapConnector<N extends Entity, E extends Entity>
extends AbstractOverlapConnector<N, E> {
    private boolean allowNulls = Boolean.getBoolean("org.geneweaver.io.connector.ALLOW_NULL_IN_PEAKID");
    private boolean allowNoTissue = Boolean.parseBoolean(System.getProperty("org.geneweaver.io.connector.ALLOW_NOTISSUE_IN_PEAKID", "true"));
    private String peakFeatureFilter = null;
    private static final Pattern datedName = Pattern.compile("^(.*)\\.peaks\\.(\\d+)\\.bed\\.gz$");
    private long roughBPperChr = 200000000L;

    public PeakOverlapConnector() {
        this("peaks");
    }

    public PeakOverlapConnector(String databaseFileName) {
        this.setTableName(System.getProperty("gweaver.mappingdb.tableName", "REGIONS"));
        this.setFileName(databaseFileName);
        this.setFileFilters(".bed.gz", ".bed");
        this.setNewestInDirectoryByName(true);
    }

    @Override
    Collection<Path> addAll(Path dir, int limit) throws IOException {
        super.addAll(dir, limit);
        this.source = this.removeOlderNames(this.source);
        return this.source;
    }

    private Collection<Path> removeOlderNames(Collection<Path> paths) {
        ArrayList<Path> rev = new ArrayList<Path>(paths);
        Collections.reverse(rev);
        HashSet<String> checked = new HashSet<String>();
        Iterator it = rev.iterator();
        while (it.hasNext()) {
            Path path = (Path)it.next();
            String fileName = path.getFileName().toString();
            Matcher matcher = datedName.matcher(fileName);
            if (!matcher.matches()) continue;
            String stub = matcher.group(1);
            if (checked.contains(stub)) {
                it.remove();
                continue;
            }
            checked.add(stub);
        }
        return rev;
    }

    @Override
    protected Located createIntersectionObject(String id, int start, int end) {
        return new Peak(id, start, end);
    }

    @Override
    protected boolean testId(String peakId) {
        if (!this.allowNulls && peakId.contains("null")) {
            logger.info("Peak missing information: " + peakId);
            return false;
        }
        if (!this.allowNoTissue && peakId.endsWith("-t")) {
            logger.info("Peak missing tissue information: " + peakId);
            return false;
        }
        return true;
    }

    @Override
    protected boolean filter(Located loc) {
        if (loc instanceof Peak) {
            Peak p = (Peak)loc;
            return PeakOverlapConnector.filter(p, this.peakFeatureFilter);
        }
        return true;
    }

    public static boolean filter(Peak p, String peakFeatureFilter) {
        if (peakFeatureFilter == null) {
            return true;
        }
        if (p.getFeatureType() == null && peakFeatureFilter != null) {
            return false;
        }
        if (p.getFeatureType() != null && peakFeatureFilter != null) {
            if (p.getFeatureType().equalsIgnoreCase(peakFeatureFilter)) {
                return true;
            }
            return p.getFeatureType().matches(peakFeatureFilter);
        }
        return true;
    }

    int testAddRandomRows(String chr, int nrows) throws SQLException {
        for (int i = 0; i < nrows; ++i) {
            Peak peak = new Peak();
            peak.setPeakId(UUID.randomUUID().toString());
            peak.setStart((int)(Math.random() * (double)this.roughBPperChr));
            peak.setEnd((int)(Math.random() * (double)this.roughBPperChr));
            peak.setChr(chr);
            this.store(peak, null, null);
            if (i % 1000000 != 0) continue;
            System.out.println("Added randoms, size " + i);
        }
        return nrows;
    }

    public boolean isAllowNulls() {
        return this.allowNulls;
    }

    public void setAllowNulls(boolean allowNulls) {
        this.allowNulls = allowNulls;
    }

    public boolean isAllowNoTissue() {
        return this.allowNoTissue;
    }

    public void setAllowNoTissue(boolean allowNoTissue) {
        this.allowNoTissue = allowNoTissue;
    }

    public String getPeakFeatureFilter() {
        return this.peakFeatureFilter;
    }

    public void setPeakFeatureFilter(String peakFeatureFilter) {
        this.peakFeatureFilter = peakFeatureFilter;
    }

    @Override
    public <T extends AbstractEntity> T create(Located loc, Variant variant) {
        if (loc instanceof Peak) {
            PeakOverlap ret = new PeakOverlap();
            ret.setPeak(loc);
            ret.setVariant(variant);
            return (T)ret;
        }
        throw new IllegalArgumentException("Cannot intersect with " + String.valueOf(loc));
    }
}

