/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.io.connector;

import org.geneweaver.domain.AbstractEntity;
import org.geneweaver.domain.Entity;
import org.geneweaver.domain.Located;
import org.geneweaver.domain.RegulatoryFeature;
import org.geneweaver.domain.RegulatoryFeatureOverlap;
import org.geneweaver.domain.Variant;
import org.geneweaver.io.connector.AbstractOverlapConnector;

public class RegulatoryFeatureOverlapConnector<N extends Entity, E extends Entity>
extends AbstractOverlapConnector<N, E> {
    public RegulatoryFeatureOverlapConnector() {
        this("regfeats");
    }

    public RegulatoryFeatureOverlapConnector(String databaseFileName) {
        this.setTableName(System.getProperty("gweaver.mappingdb.tableName", "REGIONS"));
        this.setFileName(databaseFileName);
        this.setFileFilters(".gff.gz", ".gff");
        this.setNewestInDirectoryByName(true);
    }

    @Override
    protected Located createIntersectionObject(String id, int start, int end) {
        return new RegulatoryFeature(id, start, end);
    }

    @Override
    protected boolean filter(Located loc) {
        return loc instanceof RegulatoryFeature;
    }

    @Override
    public <T extends AbstractEntity> T create(Located loc, Variant variant) {
        if (loc instanceof RegulatoryFeature) {
            RegulatoryFeatureOverlap ret = new RegulatoryFeatureOverlap();
            ret.setRegFeature(loc);
            ret.setVariant(variant);
            return (T)ret;
        }
        throw new IllegalArgumentException("Cannot intersect with " + String.valueOf(loc));
    }
}

