/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.io.connector;

import com.google.common.collect.Sets;
import java.nio.file.Path;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.geneweaver.domain.AbstractEntity;
import org.geneweaver.domain.Contact;
import org.geneweaver.domain.Entity;
import org.geneweaver.domain.Gene;
import org.geneweaver.domain.Located;
import org.geneweaver.domain.Step;
import org.geneweaver.domain.Variant;
import org.geneweaver.io.IPrintStream;
import org.geneweaver.io.connector.AbstractOverlapConnector;
import org.geneweaver.io.reader.ReaderRequest;
import org.neo4j.ogm.session.Session;

public class StepConnector
extends AbstractOverlapConnector<Step, Contact> {
    private final Class<?> clazz;
    private Path parentDirectory;

    public StepConnector() {
        this.clazz = null;
        this.setTableName(System.getProperty("gweaver.mappingdb.tableName", "REGIONS"));
    }

    public StepConnector(Class<?> clazz) {
        this(clazz, clazz.getSimpleName());
    }

    public StepConnector(Class<?> clazz, String databaseFileName) {
        this.clazz = clazz;
        this.setTableName(System.getProperty("gweaver.mappingdb.tableName", "REGIONS"));
        this.setFileName(databaseFileName);
    }

    @Override
    protected Located coerce(Object e) {
        if (this.clazz == Variant.class && e instanceof Map) {
            return Entity.coerce((Map)e, new Variant());
        }
        if (this.clazz == Gene.class && e instanceof Gene) {
            StepConnector.fixId((Gene)e);
        }
        return (Located)e;
    }

    @Override
    protected void configure(ReaderRequest request) {
        if (this.clazz == Variant.class) {
            request.setDelimiter("\t");
            request.setIncludeAll(false);
        }
    }

    @Override
    protected boolean isValidClass(Object l) {
        return l.getClass() == this.clazz;
    }

    @Override
    public Stream<Contact> stream(Step step, Session session, IPrintStream log) {
        Located start = Located.at(step.getChr1(), step.getStart1(), step.getEnd1());
        Set<String> geneIds = this.lookup(start, Gene.class, "ens", log);
        Located end = Located.at(step.getChr2(), step.getStart2(), step.getEnd2());
        Set<String> rsIds = this.lookup(end, Variant.class, "rs", log);
        if (geneIds.isEmpty() || rsIds.isEmpty()) {
            return null;
        }
        return this.expand(step, geneIds, rsIds);
    }

    private Stream<Contact> expand(Step step, Set<String> geneIds, Set<String> rsIds) {
        Set combs = Sets.cartesianProduct(Arrays.asList(geneIds, rsIds));
        return combs.stream().map(ids -> this.createContact(step, (List<String>)ids, geneIds, rsIds));
    }

    private Contact createContact(Step step, List<String> ids, Set<String> geneIds, Set<String> rsIds) {
        Contact contact = Contact.of(step);
        contact.setGeneId(ids.get(0));
        contact.setRsId(ids.get(1));
        contact.setChr(step.getChr1());
        return contact;
    }

    private Set<String> lookup(Located loc, Class<?> type, String prefix, IPrintStream log) {
        this.setFileName(type.getSimpleName());
        this.setLocation(this.getParentDirectory());
        String shardName = this.oservice.getShardName(loc.getChr(), loc.getStart());
        if (shardName != null) {
            try {
                PreparedStatement lookup = this.getSelectStatement(loc.getChr(), shardName, log);
                if (lookup == null) {
                    return null;
                }
                int a = Math.min(loc.getStart(), loc.getEnd());
                lookup.setInt(1, a);
                int b = Math.max(loc.getStart(), loc.getEnd());
                lookup.setInt(2, b);
                LinkedHashSet<String> usedIds = new LinkedHashSet<String>();
                try (ResultSet res = lookup.executeQuery();){
                    if (log != null) {
                        log.println("Found " + res.getFetchSize() + " step overlaps.");
                    }
                    while (res.next()) {
                        String id = res.getString(1);
                        if (usedIds.contains(id)) {
                            logger.info("Encountered duplicate id: " + id);
                            if (log == null) continue;
                            log.println("Encountered duplicate id: " + id);
                            continue;
                        }
                        if (prefix != null && !id.toLowerCase().startsWith(prefix)) {
                            throw new IllegalArgumentException("The id '" + id + "' does not start with expected prefix " + prefix + " (case insensitive)!");
                        }
                        usedIds.add(id);
                    }
                }
                return usedIds;
            }
            catch (RuntimeException runtime) {
                throw runtime;
            }
            catch (Exception ne) {
                logger.warn("Cannot map " + String.valueOf(loc), (Throwable)ne);
            }
        }
        return Collections.emptySet();
    }

    public static Gene fixId(Gene g) {
        String geneId = g.getGeneId();
        if (geneId.contains(".")) {
            geneId = geneId.substring(0, geneId.indexOf(46));
            g.setGeneId(geneId);
        }
        return g;
    }

    public Path getParentDirectory() {
        return this.parentDirectory;
    }

    public void setParentDirectory(Path parentDirectory) {
        this.parentDirectory = parentDirectory;
    }

    @Override
    protected Located createIntersectionObject(String id, int start, int end) {
        return null;
    }

    @Override
    public <T extends AbstractEntity> T create(Located loc, Variant variant) {
        return null;
    }
}

