/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.io.connector;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.geneweaver.io.reader.MapCSVReader;
import org.geneweaver.io.reader.ReaderFactory;
import org.geneweaver.io.reader.ReaderRequest;

public class StepSorter {
    private static Map<String, String> prefixes = new HashMap<String, String>();

    public void sortCCSI(Path ccsiAnot) throws Exception {
        assert (Files.exists(ccsiAnot, new LinkOption[0]));
        Path dir = ccsiAnot.getParent();
        dir.resolve("mm").toFile().mkdirs();
        dir.resolve("hs").toFile().mkdirs();
        ReaderRequest req = new ReaderRequest(ccsiAnot.toFile());
        req.setReaderHint("MapCSVReader");
        Object reader = ReaderFactory.getReader(req);
        reader.stream().map(MapCSVReader::toAscii).map(line -> this.sortLine(dir, (Map<String, String>)line)).count();
    }

    private Map<String, String> sortLine(Path dir, Map<String, String> line) {
        try {
            String fnum = line.get("filename_num");
            String meth = line.get("method");
            int num = Integer.parseInt(fnum.toString());
            meth = meth.toLowerCase().replace(" ", "");
            String fileName = meth + "-" + num + ".step.gz";
            Path file = dir.resolve(fileName);
            if (!Files.exists(file, new LinkOption[0])) {
                if ((meth = prefixes.get(meth)) == null) {
                    throw new NullPointerException("No mapping for: " + line.get("method"));
                }
                fileName = meth + "-" + num + ".step.gz";
            }
            if (!Files.exists(file = dir.resolve(fileName), new LinkOption[0])) {
                throw new IllegalArgumentException(fileName + " does not exist");
            }
            this.prepend(file, line);
            String spec = line.get("species");
            if (spec.equalsIgnoreCase("mouse")) {
                Files.copy(file, dir.resolve("mm").resolve(file.getFileName()), new CopyOption[0]);
            } else if (spec.equalsIgnoreCase("human")) {
                Files.copy(file, dir.resolve("hs").resolve(file.getFileName()), new CopyOption[0]);
            }
            Files.delete(file);
        }
        catch (Exception ne) {
            throw new RuntimeException(ne.getMessage());
        }
        return line;
    }

    private Map<String, String> prepend(Path file, Map<String, String> line) throws IOException {
        Path tmp = Files.createTempFile(file.getParent(), "tmp", ".gz", new FileAttribute[0]);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new GZIPInputStream(Files.newInputStream(file, new OpenOption[0]))));
             BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new GZIPOutputStream(Files.newOutputStream(tmp, new OpenOption[0]))));){
            for (Map.Entry<String, String> entry : line.entrySet()) {
                String key = entry.getKey();
                String val = entry.getValue();
                writer.write("# ");
                writer.write(key);
                writer.write(" = ");
                writer.write(val);
                writer.newLine();
            }
            reader.lines().forEach(ln -> {
                try {
                    writer.write((String)ln);
                    writer.newLine();
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getMessage());
                }
            });
        }
        Files.delete(file);
        Files.copy(tmp, file, new CopyOption[0]);
        Files.delete(tmp);
        return line;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            throw new IllegalArgumentException("One argument which is the CCSI_annotation CSV file please.");
        }
        Path annot = Paths.get(args[0], new String[0]);
        StepSorter sorter = new StepSorter();
        sorter.sortCCSI(annot);
    }

    static {
        prefixes.put("chia-pet", "chia");
        prefixes.put("situhi-c", "hic");
        prefixes.put("chi-c", "hic");
        prefixes.put("hi-c", "hic");
    }
}

