/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.io.connector;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.geneweaver.domain.Sample;

public class TissueKey {
    private List<String> frags;

    public TissueKey(Sample sample) {
        this.frags = this.unmangle(sample.getTissueGroup() + " " + sample.getTissueName());
    }

    public TissueKey(String tissue) {
        this.frags = this.unmangle(tissue);
    }

    private List<String> unmangle(String id) {
        ArrayList<String> ret = new ArrayList<String>();
        if (id == null) {
            return ret;
        }
        String[] frags = id.split(" ");
        for (int i = 0; i < frags.length; ++i) {
            String frag = frags[i].toLowerCase();
            frag = frag.replace("(", "");
            if ((frag = frag.replace(")", "")).equals("tissue") && ret.size() > i - 1 && "adipose".equals(ret.get(i - 1)) || frag.equals("-")) continue;
            if (frag.equals("artery")) {
                ret.add("blood");
                ret.add("vessel");
                continue;
            }
            ret.add(frag);
        }
        if (ret.size() == 2 && frags[0].equalsIgnoreCase(frags[1])) {
            return ret.subList(0, 1);
        }
        if (ret.size() == 4 && ret.subList(0, 2).equals(ret.subList(2, 4))) {
            return ret.subList(0, 2);
        }
        if (ret.size() == 5 && ret.subList(0, 2).equals(ret.subList(3, 5))) {
            return ret.subList(2, 5);
        }
        if (ret.size() == 2 && ((String)ret.get(0)).equals("whole") && ((String)ret.get(1)).equals("blood")) {
            ret.add(0, "blood");
        }
        if (ret.size() == 3 && ((String)ret.get(0)).equals("cells") && ((String)ret.get(1)).equals("cultured")) {
            ret.set(0, "skin");
        }
        if (ret.size() == 3 && ((String)ret.get(0)).equals("cells") && ((String)ret.get(1)).equals("ebv-transformed")) {
            ret.set(0, "blood");
        }
        return ret;
    }

    public int hashCode() {
        return Objects.hash(this.frags);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TissueKey)) {
            return false;
        }
        TissueKey other = (TissueKey)obj;
        return Objects.equals(this.frags, other.frags);
    }
}

