/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.io.connector;

import org.geneweaver.domain.AbstractEntity;
import org.geneweaver.domain.Entity;
import org.geneweaver.domain.Located;
import org.geneweaver.domain.Transcript;
import org.geneweaver.domain.TranscriptOverlap;
import org.geneweaver.domain.Variant;
import org.geneweaver.io.connector.AbstractOverlapConnector;

public class TranscriptOverlapConnector<N extends Entity, E extends Entity>
extends AbstractOverlapConnector<N, E> {
    public TranscriptOverlapConnector() {
        this("transcripts");
    }

    public TranscriptOverlapConnector(String databaseFileName) {
        this.setTableName(System.getProperty("gweaver.mappingdb.tableName", "REGIONS"));
        this.setFileName(databaseFileName);
        this.setFileFilters(".gtf.gz", ".gtf");
    }

    @Override
    protected Located createIntersectionObject(String id, int start, int end) {
        return new Transcript(id, start, end);
    }

    @Override
    protected boolean filter(Located loc) {
        return loc instanceof Transcript;
    }

    @Override
    public <T extends AbstractEntity> T create(Located loc, Variant variant) {
        if (loc instanceof Transcript) {
            TranscriptOverlap ret = new TranscriptOverlap();
            ret.setTranscript(loc);
            ret.setVariant(variant);
            return (T)ret;
        }
        throw new IllegalArgumentException("Cannot intersect with " + String.valueOf(loc));
    }
}

