/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.io.connector;

import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.geneweaver.domain.Entity;
import org.geneweaver.domain.GeneticEntity;
import org.geneweaver.domain.Transcript;
import org.geneweaver.domain.Variant;
import org.geneweaver.domain.VariantEffect;
import org.geneweaver.io.IPrintStream;
import org.geneweaver.io.connector.Connector;
import org.neo4j.ogm.cypher.ComparisonOperator;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.cypher.Filters;
import org.neo4j.ogm.session.Session;

public class VariantConnector<N extends GeneticEntity, E extends Entity>
implements Connector<N, E>,
Function<N, Stream<E>> {
    private Map<String, SoftReference<Transcript>> cache = new HashMap<String, SoftReference<Transcript>>();
    private boolean useSessions;

    public VariantConnector() {
        this(false);
    }

    public VariantConnector(boolean useSessions) {
        this.useSessions = useSessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Stream<E> apply(GeneticEntity ge) {
        Variant v = (Variant)ge;
        try {
            if (v.getVariantEffect() == null || v.getVariantEffect().isEmpty()) {
                Stream<Variant> stream = Stream.of(v);
                return stream;
            }
            Collection ve = v.getVariantEffect().stream().filter(e -> e != null).filter(e -> e.getFeatureId() != null).filter(e -> !e.getFeatureId().trim().isBlank()).map(e -> {
                e.setVariant(v);
                return e;
            }).collect(Collectors.toSet());
            LinkedList<Variant> ret = new LinkedList<Variant>();
            ret.add(v);
            ret.addAll(ve);
            Stream stream = ret.stream();
            return stream;
        }
        finally {
            v.clearEffects();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Stream<E> stream(N ge, Session session, IPrintStream log) {
        if (!this.useSessions) {
            return this.apply((GeneticEntity)ge);
        }
        Variant v = (Variant)ge;
        try {
            if (v.getVariantEffect() == null || v.getVariantEffect().isEmpty()) {
                Stream<Variant> stream = Stream.of(v);
                return stream;
            }
            Set<String> transIds = v.getVariantEffect().stream().filter(e -> e != null).filter(e -> e.getFeatureId() != null).filter(e -> !e.getFeatureId().trim().isBlank()).map(e -> e.getFeatureId()).collect(Collectors.toSet());
            if (transIds.isEmpty()) {
                Stream<Variant> stream = Stream.of(v);
                return stream;
            }
            Map<String, Transcript> allTranscripts = this.getCachedFilters(transIds, session);
            Collection ve = v.getVariantEffect().stream().map(e -> this.registerTranscript(v, (VariantEffect)e, allTranscripts)).filter(t -> t != null).collect(Collectors.toSet());
            LinkedList<Variant> ret = new LinkedList<Variant>();
            ret.add(v);
            ret.addAll(ve);
            Stream stream = ret.stream();
            return stream;
        }
        finally {
            v.clearEffects();
        }
    }

    private Map<String, Transcript> getCachedFilters(Set<String> transIds, Session session) {
        HashMap<String, Transcript> allTranscripts = new HashMap<String, Transcript>();
        Filters filters = new Filters();
        for (String tid : transIds) {
            if (this.cache.containsKey(tid)) {
                SoftReference<Transcript> ref = this.cache.get(tid);
                if (ref == null) continue;
                Transcript t2 = ref.get();
                if (t2 != null) {
                    allTranscripts.put(tid, t2);
                    continue;
                }
                this.cache.remove(tid);
            }
            filters = filters.or(new Filter("transcriptId", ComparisonOperator.EQUALS, (Object)tid));
        }
        if (!filters.isEmpty()) {
            Collection transcripts = session.loadAll(Transcript.class, filters);
            Map<String, Transcript> tmap = transcripts.stream().collect(Collectors.toMap(t -> t.getTranscriptId(), t -> t));
            for (String tid : tmap.keySet()) {
                this.cache.put(tid, new SoftReference<Transcript>(tmap.get(tid)));
            }
            allTranscripts.putAll(tmap);
        }
        transIds.removeAll(allTranscripts.keySet());
        for (String tid : transIds) {
            this.cache.put(tid, null);
        }
        return allTranscripts;
    }

    private VariantEffect registerTranscript(Variant v, VariantEffect e, Map<String, Transcript> tmap) {
        Transcript t = tmap.get(e.getFeatureId());
        if (t == null) {
            return null;
        }
        e.setTranscript(t);
        e.setVariant(v);
        return e;
    }
}

