/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.io.reader;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import java.util.zip.GZIPInputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.IOUtils;
import org.geneweaver.domain.Entity;
import org.geneweaver.io.reader.ReaderException;
import org.geneweaver.io.reader.ReaderRequest;
import org.geneweaver.io.reader.StreamReader;

public abstract class AbstractCSVReader<T>
implements StreamReader<T> {
    private ReaderRequest request;
    private int lines;
    private List<String> headerOverride;

    @Override
    public AbstractCSVReader<T> init(ReaderRequest request) {
        if (request.getDelimiter() == null) {
            request.setDelimiter(",");
        }
        this.request = request;
        this.lines = 0;
        return this;
    }

    protected abstract T create(CSVRecord var1) throws ReaderException;

    @Override
    public Stream<T> stream() throws ReaderException {
        try {
            BufferedReader in = this.createReader(this.request);
            char delim = this.request.getDelimiter().charAt(0);
            CSVParser records = this.getFormat(delim).parse((Reader)in);
            return ((Stream)StreamSupport.stream(records.spliterator(), false).onClose(() -> IOUtils.closeQuietly((Closeable)in, ex -> {
                throw new RuntimeException((Throwable)ex);
            }))).map(rec -> {
                try {
                    return this.create((CSVRecord)rec);
                }
                catch (Exception ne) {
                    throw new RuntimeException(ne);
                }
            }).filter(m -> m != null).map(t -> {
                ++this.lines;
                return t;
            });
        }
        catch (IOException ne) {
            throw new ReaderException(ne);
        }
    }

    public List<String> headers() throws ReaderException {
        if (this.headerOverride != null) {
            return this.headerOverride;
        }
        try {
            BufferedReader in = this.createReader(this.request);
            char delim = this.request.getDelimiter().charAt(0);
            return this.getFormat(delim).parse((Reader)in).getHeaderNames();
        }
        catch (IOException ne) {
            throw new ReaderException(ne);
        }
    }

    private CSVFormat getFormat(char delim) {
        CSVFormat.Builder builder = CSVFormat.DEFAULT.builder().setCommentMarker('#');
        builder = this.headerOverride != null ? builder.setHeader(this.headerOverride.toArray(new String[this.headerOverride.size()])).setSkipHeaderRecord(false) : builder.setHeader(new String[0]).setSkipHeaderRecord(true);
        builder = builder.setDelimiter(delim).setTrim(true).setIgnoreEmptyLines(true).setTrailingDelimiter(true);
        if (!this.request.isIncludeAll()) {
            builder = builder.setAllowMissingColumnNames(true);
        }
        return builder.build();
    }

    private BufferedReader createReader(ReaderRequest req) throws IOException {
        InputStream in;
        boolean gz = false;
        if (req.getStream() != null) {
            in = req.getStream();
            gz = req.getName().toLowerCase().endsWith(".gz");
        } else {
            in = Files.newInputStream(req.getFile().toPath(), new OpenOption[0]);
            gz = req.getFile().getName().toLowerCase().endsWith(".gz");
        }
        if (gz) {
            in = new GZIPInputStream(in);
        }
        return new BufferedReader(new InputStreamReader(in));
    }

    @Override
    public <U extends Entity> Function<T, Stream<U>> getDefaultConnector() {
        return null;
    }

    @Override
    public int linesProcessed() {
        return this.lines;
    }

    @Override
    public boolean isDataSource() {
        return this.request.isFileRequest();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public void close() throws IOException {
    }

    protected String getSpecies() {
        return this.request.getSource();
    }

    @Override
    public int getChunkSize() {
        return -1;
    }

    @Override
    public void setChunkSize(int chunkSize) {
    }

    @Override
    public List<T> wind() throws ReaderException {
        throw new ReaderException("Wind is not supported by " + this.getClass().getSimpleName());
    }

    public List<String> getHeaderOverride() {
        return this.headerOverride;
    }

    public void setHeaderOverride(List<String> headerOverride) {
        this.headerOverride = headerOverride;
    }

    public void readHeadersFromLastCommentLine() throws IOException, ReaderException {
        if (!this.request.isFileRequest()) {
            throw new ReaderException("Reading headers from last comment line is only supported in file mode!");
        }
        try (BufferedReader reader = this.createReader(this.request);){
            String line = null;
            String previousline = null;
            while ((line = reader.readLine()) != null) {
                if (!(line = line.trim()).startsWith("#")) {
                    previousline = previousline.substring(1);
                    String delim = this.request.getDelimiter().substring(0, 1);
                    String[] headers = previousline.split(delim);
                    this.setHeaderOverride(Arrays.asList(headers));
                    return;
                }
                previousline = line;
            }
            throw new ReaderException("Last line of headers not found!");
        }
    }
}

