/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.io.reader;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.geneweaver.domain.Entity;
import org.geneweaver.io.reader.ReaderException;
import org.geneweaver.io.reader.ReaderRequest;
import org.geneweaver.io.reader.StreamReader;

public abstract class AbstractStreamReader<T extends Entity>
implements StreamReader<T> {
    protected ReaderRequest request;
    protected String entryName;
    protected int chunkSize = Integer.getInteger("org.geneweaver.io.windForward", 4096);
    private Iterator<T> iterator;

    @Override
    public <R extends StreamReader<T>> R init(ReaderRequest request) throws ReaderException {
        this.request = request;
        return (R)this;
    }

    @Override
    public int getChunkSize() {
        return this.chunkSize;
    }

    @Override
    public void setChunkSize(int windForwardAmount) {
        this.chunkSize = windForwardAmount;
    }

    @Override
    public List<T> wind() throws ReaderException {
        if (this.iterator == null || !this.iterator.hasNext()) {
            this.iterator = this.stream().iterator();
        }
        LinkedList<Entity> ls = new LinkedList<Entity>();
        for (int i = 0; i < this.getChunkSize() && this.iterator.hasNext(); ++i) {
            ls.add((Entity)this.iterator.next());
        }
        return ls;
    }

    public String getEntryName() {
        return this.entryName;
    }

    protected String getCurrentFileName() {
        String name = this.getEntryName();
        return name != null ? name.substring(name.indexOf(47) + 1) : this.request.name();
    }

    public void setEntryName(String entryName) {
        this.entryName = entryName;
    }

    @Override
    public <U extends Entity> Function<T, Stream<U>> getDefaultConnector() {
        throw new RuntimeException("No connector for " + this.getClass().getSimpleName());
    }

    protected Map<String, Integer> parseIndices(String[] segs) {
        HashMap<String, Integer> indices = new HashMap<String, Integer>();
        for (int i = 0; i < segs.length; ++i) {
            indices.put(segs[i].toLowerCase(), i);
        }
        return indices;
    }
}

