/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.io.reader;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.geneweaver.domain.Entity;
import org.geneweaver.io.reader.AbstractStreamReader;
import org.geneweaver.io.reader.ReaderException;
import org.geneweaver.io.reader.ReaderFactory;
import org.geneweaver.io.reader.ReaderRequest;
import org.geneweaver.io.reader.StreamReader;

public class ArchiveReader<T extends Entity>
extends AbstractStreamReader<T> {
    private Iterator<T> iterator;
    private int linesProcessed;

    @Override
    public Stream<T> stream() throws ReaderException {
        try {
            this.linesProcessed = 0;
            this.iterator = this.createIterator(false);
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator, 16), false);
        }
        catch (IOException e) {
            throw new ReaderException(e);
        }
    }

    @Override
    public List<T> wind() throws ReaderException {
        try {
            if (this.iterator == null) {
                this.iterator = this.createIterator(false);
            }
            StreamReader reader = ((StreamIterator)this.iterator).getActiveReader();
            return reader.wind();
        }
        catch (IOException e) {
            throw new ReaderException(e);
        }
    }

    @Override
    public boolean isEmpty() {
        if (this.iterator == null) {
            return false;
        }
        try {
            StreamReader reader = ((StreamIterator)this.iterator).getActiveReader();
            return reader.isEmpty();
        }
        catch (IOException | ReaderException e) {
            return true;
        }
    }

    private Iterator<T> createIterator(boolean closeStream) throws IOException, ReaderException {
        String name = this.request.name();
        if (name.toLowerCase().endsWith(".zip")) {
            return new ZipIterator(this.request.stream());
        }
        if (name.toLowerCase().endsWith(".tar")) {
            return new TarIterator(this.request.stream());
        }
        throw new IllegalArgumentException("Cannot find archive reader for " + name);
    }

    @Override
    public <U extends Entity> Function<T, Stream<U>> getDefaultConnector() {
        throw new IllegalArgumentException("An archive may contain different files of different types!");
    }

    @Override
    public int linesProcessed() {
        return this.linesProcessed;
    }

    @Override
    public boolean isDataSource() {
        return this.request.isFileRequest();
    }

    @Override
    public void close() throws IOException {
        if (this.iterator != null && this.iterator instanceof Closeable) {
            ((Closeable)((Object)this.iterator)).close();
        }
    }

    private abstract class StreamIterator
    implements Iterator<T>,
    Closeable {
        protected InputStream parent;
        protected Iterator<T> currentIterator;
        protected AbstractStreamReader<T> reader;

        public StreamIterator(InputStream in) throws IOException {
            this.parent = in;
        }

        public StreamReader<T> getActiveReader() throws IOException, ReaderException {
            if (this.reader != null && !this.reader.isEmpty()) {
                return this.reader;
            }
            this.nextIterator();
            return this.reader;
        }

        @Override
        public boolean hasNext() {
            if (this.currentIterator == null) {
                return false;
            }
            boolean more = this.currentIterator.hasNext();
            if (!more) {
                ArchiveReader.this.linesProcessed += this.reader.linesProcessed();
            }
            return more;
        }

        @Override
        public T next() {
            if (this.currentIterator == null) {
                return null;
            }
            Entity next = (Entity)this.currentIterator.next();
            if (!this.currentIterator.hasNext()) {
                ArchiveReader.this.linesProcessed += this.reader.linesProcessed();
                try {
                    this.currentIterator = this.nextIterator();
                }
                catch (IOException | ReaderException e) {
                    throw new RuntimeException(e);
                }
            }
            return next;
        }

        protected abstract Iterator<T> nextIterator() throws IOException, ReaderException;

        protected boolean isEntryValid(String name) {
            if (name == null) {
                return false;
            }
            return ArchiveReader.this.request.getFileFilter() == null || name.matches(ArchiveReader.this.request.getFileFilter());
        }

        @Override
        public void close() throws IOException {
            this.parent.close();
        }
    }

    private class ZipIterator
    extends StreamIterator {
        private ZipInputStream zstream;

        public ZipIterator(InputStream in) throws IOException, ReaderException {
            super(new ZipInputStream(in));
            this.zstream = (ZipInputStream)this.parent;
            this.currentIterator = this.nextIterator();
        }

        @Override
        protected Iterator<T> nextIterator() throws IOException, ReaderException {
            ZipEntry entry = this.zstream.getNextEntry();
            if (entry == null) {
                return null;
            }
            while (!this.isEntryValid(entry.getName())) {
                entry = this.zstream.getNextEntry();
                if (entry != null) continue;
                return null;
            }
            this.reader = (AbstractStreamReader)ReaderFactory.getReader(new ReaderRequest(this.zstream, entry.getName(), false));
            this.reader.setChunkSize(ArchiveReader.this.getChunkSize());
            this.reader.setEntryName(entry.getName());
            return this.reader.stream().iterator();
        }
    }

    private class TarIterator
    extends StreamIterator {
        private TarArchiveInputStream tstream;

        public TarIterator(InputStream in) throws IOException, ReaderException {
            super((InputStream)new TarArchiveInputStream(in));
            this.tstream = (TarArchiveInputStream)this.parent;
            this.currentIterator = this.nextIterator();
        }

        @Override
        protected Iterator<T> nextIterator() throws IOException, ReaderException {
            TarArchiveEntry entry = this.tstream.getNextTarEntry();
            if (entry == null) {
                return null;
            }
            while (!this.isEntryValid(entry.getName())) {
                entry = this.tstream.getNextTarEntry();
                if (entry != null) continue;
                return null;
            }
            this.reader = (AbstractStreamReader)ReaderFactory.getReader(new ReaderRequest((InputStream)this.tstream, entry.getName(), false));
            this.reader.setChunkSize(ArchiveReader.this.getChunkSize());
            this.reader.setEntryName(entry.getName());
            return this.reader.stream().iterator();
        }
    }
}

