/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.io.reader;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.beanutils.BeanMap;
import org.geneweaver.domain.Entity;
import org.geneweaver.domain.NamedEntity;
import org.geneweaver.domain.Peak;
import org.geneweaver.domain.Species;
import org.geneweaver.domain.Track;
import org.geneweaver.io.connector.BedConnector;
import org.geneweaver.io.connector.ChromosomeService;
import org.geneweaver.io.reader.LineIteratorReader;
import org.geneweaver.io.reader.ReaderException;
import org.geneweaver.io.reader.ReaderFactory;
import org.geneweaver.io.reader.ReaderRequest;

public class BedReader<N extends NamedEntity>
extends LineIteratorReader<N> {
    private ChromosomeService cservice = ChromosomeService.getInstance();
    private static final Pattern pattern = Pattern.compile("([a-zA-Z0-9]+)_([a-zA-Z0-9_]+)__Enriched_Site");
    private static final Map<String, Map<String, String>> descriptions = new HashMap<String, Map<String, String>>();
    private static Pattern postPattern = Pattern.compile("([a-z0-9]+?)(postnatal(\\d+)days)");
    private static Pattern embPattern = Pattern.compile("([a-z0-9]+?)(embryonic(\\d+)days)");
    private static Pattern daysPattern = Pattern.compile("([a-z0-9]+?)\\d+days");
    private static Pattern weeksPattern = Pattern.compile("([a-z0-9]+?)\\d+weeks");

    @Override
    public BedReader<N> init(ReaderRequest request) throws ReaderException {
        super.setup(request);
        this.setDelimiter("\\s+");
        return this;
    }

    @Override
    protected N create(String line) throws ReaderException {
        NamedEntity ret;
        if (line.startsWith("track ")) {
            String ln = line.substring(5);
            Map<String, String> attr = this.parseQuotedAttributes(ln);
            Track track = new Track();
            BeanMap d = new BeanMap((Object)track);
            d.put((Object)"name", (Object)attr.get("name"));
            d.put((Object)"type", (Object)attr.get("type"));
            d.put((Object)"graphType", (Object)attr.get("graphType"));
            d.put((Object)"description", (Object)attr.get("description"));
            if (attr.containsKey("priority")) {
                d.put((Object)"priority", (Object)attr.get("priority"));
            }
            if (attr.containsKey("color")) {
                track.setColor(this.getIntArray(attr.get("color"), 3));
            }
            if (attr.containsKey("useScore")) {
                d.put((Object)"useScore", (Object)attr.get("useScore"));
            }
            if (attr.containsKey("itemRgb")) {
                String val = attr.get("itemRgb");
                track.setItemRgb("on".equals(val));
            }
            ret = track;
        } else {
            String[] rec = line.split(this.getDelimiter());
            Peak peak = new Peak();
            BeanMap d = new BeanMap((Object)peak);
            String chrom = this.cservice.getChromosome(rec[0]);
            if (chrom == null) {
                return null;
            }
            d.put((Object)"chr", (Object)chrom);
            d.put((Object)"start", (Object)rec[1]);
            d.put((Object)"end", (Object)rec[2]);
            if (rec.length > 3) {
                d.put((Object)"name", (Object)rec[3]);
            }
            if (rec.length > 4) {
                d.put((Object)"score", (Object)rec[4]);
            }
            if (rec.length > 5) {
                d.put((Object)"strand", (Object)Peak.Strand.from(rec[5]));
            }
            if (rec.length > 6) {
                d.put((Object)"thickStart", (Object)rec[6]);
            }
            if (rec.length > 7) {
                d.put((Object)"thickEnd", (Object)rec[7]);
            }
            if (rec.length > 8) {
                peak.setItemRgb(this.getIntArray(rec[8], 3));
            }
            if (rec.length > 9) {
                d.put((Object)"blockCount", (Object)rec[9]);
            }
            if (rec.length > 10) {
                d.put((Object)"blockSizes", (Object)this.getIntArray(rec[10], 1));
            }
            if (rec.length > 11) {
                d.put((Object)"blockStarts", (Object)this.getIntArray(rec[11], 1));
            }
            this.parseName(d);
            String epi = peak.getEpigenome();
            String feat = peak.getFeatureType();
            if (epi == null && feat != null) {
                return null;
            }
            this.createPeakId(peak);
            ret = peak;
        }
        ret.setSpecies(this.getSpecies());
        return (N)ret;
    }

    @Override
    public Stream<N> stream() {
        return super.stream();
    }

    private Peak createPeakId(Peak peak) {
        int start = peak.getStart();
        int end = peak.getEnd();
        String peakId = BedReader.createPeakId(peak.getFeatureType(), peak.getChr(), start, end, peak.getTissueDescription());
        peak.setPeakId(peakId);
        return peak;
    }

    public static String createPeakId(String featType, String chr, int start, int end, String tissue) {
        StringBuilder buf = new StringBuilder();
        buf.append(featType);
        buf.append("@");
        buf.append(chr);
        buf.append("#");
        buf.append(start);
        buf.append(":");
        buf.append(end);
        String tc = tissue != null && !tissue.isBlank() ? "+t" : "-t";
        buf.append(tc);
        return buf.toString();
    }

    private void parseName(BeanMap d) throws ReaderException {
        String ekey;
        String descr;
        Object name = d.get((Object)"name");
        if (name == null) {
            return;
        }
        Matcher matcher = pattern.matcher(name.toString());
        if (!matcher.matches()) {
            return;
        }
        d.put((Object)"featureType", (Object)matcher.group(1));
        String egen = matcher.group(2);
        d.put((Object)"epigenome", (Object)egen);
        Map<String, String> des = this.getEpigenomeDescriptions(this.getSpecies());
        if (des != null && (descr = des.get(ekey = BedReader.getKey(egen))) != null) {
            d.put((Object)"tissueDescription", (Object)descr);
        }
    }

    Peak testParseName(String name) throws ReaderException {
        Peak peak = new Peak(name);
        this.parseName(new BeanMap((Object)peak));
        return peak;
    }

    private int[] getIntArray(String string, int min) {
        String[] col = string.split(",");
        LinkedList<Integer> ret = new LinkedList<Integer>();
        for (String c : col) {
            ret.add(Integer.parseInt(c));
        }
        if (ret.size() < min) {
            for (int i = ret.size(); i < min; ++i) {
                ret.add(0);
            }
        }
        return this.toArray(ret);
    }

    private int[] toArray(Collection<Integer> ret) {
        int[] ia = new int[ret.size()];
        Iterator<Integer> it = ret.iterator();
        for (int i = 0; i < ia.length; ++i) {
            ia[i] = it.next();
        }
        return ia;
    }

    @Override
    protected String getAssignmentChar() {
        return "=";
    }

    @Override
    public <U extends Entity> Function<N, Stream<U>> getDefaultConnector() {
        BedConnector func = new BedConnector();
        return func;
    }

    Map<String, String> getEpigenomeDescriptions(Integer speciesCode) throws ReaderException {
        String species = Species.getSpeciesName(speciesCode);
        if (species == null) {
            return Collections.emptyMap();
        }
        if (descriptions.get(species) != null) {
            return descriptions.get(species);
        }
        String path = "/epigenome_description/" + species.replace(" ", "_") + ".tsv";
        InputStream in = this.getClass().getResourceAsStream(path);
        if (in == null) {
            try {
                String local = "src/main/resources" + path;
                in = Files.newInputStream(Paths.get(local, new String[0]), new OpenOption[0]);
            }
            catch (IOException ignored) {
                return null;
            }
        }
        ReaderRequest req = new ReaderRequest(species, in, path);
        req.setReaderHint("MapCSVReader");
        req.setDelimiter("\t");
        Object lines = ReaderFactory.getReader(req);
        HashMap<String, String> fdescr = new HashMap<String, String>();
        lines.stream().forEach(m -> {
            String ekey = BedReader.getKey((String)m.get("Epigenome"));
            String des = (String)m.get("Description");
            fdescr.put(ekey, des);
        });
        descriptions.put(species, fdescr);
        return fdescr;
    }

    public static String getKey(String origName) {
        Matcher weeks;
        Matcher days;
        Matcher emb;
        Object keyName = origName.toLowerCase();
        Matcher post = postPattern.matcher((CharSequence)(keyName = ((String)keyName).replaceAll("[^a-z0-9]+", "")));
        if (post.matches()) {
            keyName = post.group(1) + "p" + post.group(3);
        }
        if ((emb = embPattern.matcher((CharSequence)keyName)).matches()) {
            keyName = emb.group(1) + "e" + emb.group(3);
        }
        if ((days = daysPattern.matcher((CharSequence)keyName)).matches()) {
            keyName = days.group(1);
        }
        if ((weeks = weeksPattern.matcher((CharSequence)keyName)).matches()) {
            keyName = weeks.group(1);
        }
        return keyName;
    }
}

