/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.io.reader;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.geneweaver.domain.Anchor;
import org.geneweaver.domain.AnchoredEntity;
import org.geneweaver.domain.ChromatinInteraction;
import org.geneweaver.domain.ExperimentMetadata;
import org.geneweaver.io.reader.AbstractXlsReader;

class ChiapetReader<N extends AnchoredEntity>
extends AbstractXlsReader<N, ExperimentMetadata> {
    ChiapetReader() {
    }

    @Override
    protected N create(Row row) {
        Class<Object> concrete = this.getConcreteClass();
        try {
            if (concrete == null) {
                concrete = ChromatinInteraction.class;
            }
        }
        catch (RuntimeException ne) {
            throw new IllegalArgumentException("Please set the concrete class on " + this.getClass().getSimpleName(), ne);
        }
        Cell cell = row.getCell(0);
        if (cell == null) {
            return null;
        }
        String chr = cell.getStringCellValue();
        if (chr == null) {
            return null;
        }
        if (!chr.matches("chr(\\d+|X|Y|M)")) {
            return null;
        }
        if (concrete == ChromatinInteraction.class) {
            ChromatinInteraction c = new ChromatinInteraction();
            c.setChr(chr);
            ExperimentMetadata meta = (ExperimentMetadata)this.getMeta();
            if (meta != null) {
                meta.setChr(chr);
            }
            c.setMeta(meta);
            c.setLeft(this.createAnchor(row, 0, 1, 2));
            c.setRight(this.createAnchor(row, 3, 4, 5));
            c.setPetCount((int)Math.round(row.getCell(6).getNumericCellValue()));
            c.setP(row.getCell(7).getNumericCellValue());
            c.setFdr(row.getCell(8).getNumericCellValue());
            String overlap = row.getCell(9) != null ? row.getCell(9).getStringCellValue() : null;
            c.setOverlapDNAPET("Yes".equalsIgnoreCase(overlap));
            return (N)c;
        }
        if (concrete == Anchor.class) {
            return (N)this.createAnchor(row, 0, 1, 2, 3);
        }
        throw new IllegalArgumentException("Class " + String.valueOf(this.getConcreteClass()) + " cannot be pared using " + this.getClass().getSimpleName());
    }

    private Anchor createAnchor(Row row, int i, int j, int k, int l) {
        return new Anchor(row.getCell(i).getStringCellValue(), (int)Math.round(row.getCell(j).getNumericCellValue()), (int)Math.round(row.getCell(k).getNumericCellValue()), (int)Math.round(row.getCell(l).getNumericCellValue()));
    }

    private Anchor createAnchor(Row row, int i, int j, int k) {
        return new Anchor(row.getCell(i).getStringCellValue(), (int)Math.round(row.getCell(j).getNumericCellValue()), (int)Math.round(row.getCell(k).getNumericCellValue()));
    }
}

