/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.io.reader;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class Expander
implements Closeable {
    private final Path dir;
    private final boolean deleteOnExit;

    public Expander() throws IOException {
        this(Files.createTempDirectory("Expand", new FileAttribute[0]), true);
    }

    public Expander(Path dir) {
        this(dir, true);
    }

    public Expander(Path dir, boolean deleteOnExit) {
        this.dir = dir;
        this.deleteOnExit = deleteOnExit;
    }

    public List<Path> expand(Path zip) throws ZipException, IOException {
        ArrayList<Path> pathsExpanded = new ArrayList<Path>();
        File outputDir = this.dir.toFile();
        outputDir.mkdirs();
        try (ZipFile zipFile = new ZipFile(zip.toFile());){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File des = new File(outputDir, entry.getName());
                if (this.deleteOnExit) {
                    des.deleteOnExit();
                }
                pathsExpanded.add(des.toPath());
                if (entry.isDirectory()) {
                    des.mkdirs();
                    continue;
                }
                des.getParentFile().mkdirs();
                des.createNewFile();
                InputStream in = zipFile.getInputStream(entry);
                try (FileOutputStream out = new FileOutputStream(des);){
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
        }
        return pathsExpanded;
    }

    @Override
    public void close() {
        try {
            FileUtils.deleteDirectory((File)this.dir.toFile());
        }
        catch (IOException e) {
            if (Files.exists(this.dir, new LinkOption[0]) && this.dir.toFile().list().length < 1) {
                return;
            }
            throw new RuntimeException(e);
        }
    }

    public Path getDir() {
        return this.dir;
    }

    public boolean isDeleteOnExit() {
        return this.deleteOnExit;
    }
}

