/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.io.reader;

import java.util.function.Function;
import java.util.stream.Stream;
import org.geneweaver.domain.Entity;
import org.geneweaver.domain.Fantom5Link;
import org.geneweaver.domain.NamedEntity;
import org.geneweaver.io.reader.LineIteratorReader;
import org.geneweaver.io.reader.ReaderException;
import org.geneweaver.io.reader.ReaderRequest;

class Fantom5EnsemblMapReader<N extends NamedEntity>
extends LineIteratorReader<N> {
    Fantom5EnsemblMapReader() {
    }

    @Override
    public Fantom5EnsemblMapReader<N> init(ReaderRequest request) throws ReaderException {
        super.setup(request);
        this.setDelimiter("\\t+");
        return this;
    }

    @Override
    public <U extends Entity> Function<N, Stream<U>> getDefaultConnector() {
        return null;
    }

    @Override
    protected N create(String line) throws ReaderException {
        String[] rec = line.split(this.getDelimiter());
        Fantom5Link link = new Fantom5Link();
        link.setUid(Long.parseLong(rec[0]));
        link.setChrom("chr" + rec[1]);
        link.setStart(Integer.parseInt(rec[2]));
        link.setEnd(Integer.parseInt(rec[3]));
        link.setName(rec[4]);
        link.addEnsemblIds(rec[5].split("|"));
        return (N)link;
    }
}

