/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.io.reader;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.beanutils.BeanMap;
import org.geneweaver.domain.Entity;
import org.geneweaver.domain.VariantCall;
import org.geneweaver.io.reader.LineIteratorReader;
import org.geneweaver.io.reader.ReaderException;
import org.geneweaver.io.reader.ReaderRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastVCFReader<N extends Entity>
extends LineIteratorReader<N> {
    private static Logger logger = LoggerFactory.getLogger(FastVCFReader.class);
    private List<String> headerNames;

    @Override
    public FastVCFReader<N> init(ReaderRequest request) throws ReaderException {
        super.setup(request);
        this.setDelimiter("\t");
        return this;
    }

    @Override
    protected N create(String line) throws ReaderException {
        if (this.headerNames == null) {
            if (this.header == null || this.header.isEmpty()) {
                throw new ReaderException("VCF files must have a header!");
            }
            String headLine = (String)this.header.get(this.header.size() - 1);
            String[] names = headLine.substring(1).split(this.getDelimiter());
            this.headerNames = Arrays.asList(names);
        }
        VariantCall bean = new VariantCall();
        BeanMap d = new BeanMap((Object)bean);
        String sline = line;
        for (int i = 0; i < this.headerNames.size(); ++i) {
            String name = this.headerNames.get(i).toLowerCase();
            int loc = sline.indexOf(this.getDelimiter());
            if (loc < 0) continue;
            Object value = sline.substring(0, loc);
            if (this.headerNames.get(i).equals("INFO")) {
                value = this.parseAttributes(value.toString());
            }
            sline = sline.substring(loc + 1);
            try {
                d.put((Object)name, value);
            }
            catch (NumberFormatException ne) {
                logger.info("The property '" + name + "' cannot have value: " + String.valueOf(value));
                continue;
            }
            if (name.equalsIgnoreCase("FORMAT")) break;
        }
        return (N)bean;
    }

    @Override
    protected void addHeader(String line) {
        this.headerNames = null;
        super.addHeader(line);
    }
}

