/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.io.reader;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.commons.beanutils.BeanMap;
import org.geneweaver.domain.EQTL;
import org.geneweaver.domain.Entity;
import org.geneweaver.io.reader.LineIteratorReader;
import org.geneweaver.io.reader.ReaderException;
import org.geneweaver.io.reader.ReaderRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlexEQTLReader<N extends Entity>
extends LineIteratorReader<N> {
    private static Logger logger = LoggerFactory.getLogger(FlexEQTLReader.class);
    private List<String> columnNames;
    private Map<String, Object> headerValues;
    private DateFormat format = new SimpleDateFormat("MM/dd/yyyy");

    @Override
    public FlexEQTLReader<N> init(ReaderRequest request) throws ReaderException {
        this.setDelimiter(request.getDelimiter() == null ? "\\t" : request.getDelimiter());
        super.setup(request);
        return this;
    }

    @Override
    protected N create(String line) throws ReaderException {
        boolean lineIsHeader;
        if (line == null || line.isBlank()) {
            return null;
        }
        if ((this.columnNames == null || this.headerValues == null) && (lineIsHeader = this.parseHeaders(line))) {
            return null;
        }
        EQTL bean = new EQTL();
        BeanMap d = new BeanMap((Object)bean);
        String[] values = line.split(this.getDelimiter());
        if (values.length != this.columnNames.size()) {
            throw new ReaderException("There are a different number of headers and values!");
        }
        for (int i = 0; i < this.columnNames.size(); ++i) {
            String name = this.columnNames.get(i);
            if (!d.containsKey((Object)name)) continue;
            try {
                String value = values[i];
                if (value == null || (value = value.trim()).isEmpty()) continue;
                if ("geneId".equals(name) && value.indexOf(".") > -1) {
                    String geneId = value.substring(0, value.indexOf("."));
                    d.put((Object)"fullGeneId", (Object)value);
                    value = geneId;
                }
                d.put((Object)name, (Object)value);
                continue;
            }
            catch (NumberFormatException ne) {
                logger.info("The property '" + name + "' cannot have value: " + values[i]);
            }
        }
        this.headerValues.forEach((k, v) -> d.put(k, v));
        for (String header : this.columnNames) {
            try {
                Double.parseDouble(header);
                throw new IllegalArgumentException("No header name should be numeric!");
            }
            catch (NumberFormatException required) {
            }
        }
        return (N)bean;
    }

    private boolean parseHeaders(String line) throws ReaderException {
        String name;
        int i;
        String headLine;
        boolean lineIsHeader = false;
        if ((this.header == null || this.header.isEmpty()) && line != null) {
            this.addHeader(line);
            lineIsHeader = true;
        }
        String[] names = (headLine = (String)this.header.get(this.header.size() - 1)).trim().startsWith(this.getComment()) ? headLine.substring(1).split(this.getDelimiter()) : headLine.split(this.getDelimiter());
        this.columnNames = new ArrayList<String>();
        for (i = 0; i < names.length; ++i) {
            name = names[i];
            name = name.replace("_", "");
            if ((name = name.toLowerCase()).equals("rsid")) {
                name = "rsId";
            }
            if (name.equals("snpid")) {
                name = "rsId";
            }
            if (name.equals("geneid")) {
                name = "geneId";
            }
            if (name.equals("snpchr")) {
                name = "chr";
            }
            if (name.equals("chrsnp")) {
                name = "chr";
            }
            this.columnNames.add(name);
        }
        this.headerValues = new HashMap<String, Object>();
        for (i = 0; i < this.header.size() - 1; ++i) {
            String hline = ((String)this.header.get(i)).substring(1);
            String[] kvs = hline.split(":");
            String name2 = kvs[0].toLowerCase();
            Object value = kvs[1].trim();
            if (name2.equalsIgnoreCase("ensembl.version")) {
                name2 = "version";
            }
            if (name2.equalsIgnoreCase("tissue")) {
                name2 = "tissueName";
                value = value.toString().toLowerCase();
            }
            if (name2.equalsIgnoreCase("species")) continue;
            if (name2.equalsIgnoreCase("url")) {
                name2 = "source";
            }
            if (name2.equalsIgnoreCase("date")) {
                try {
                    value = this.format.parse(value.toString());
                    continue;
                }
                catch (ParseException e) {
                    throw new ReaderException("Cannot parse date: " + String.valueOf(value));
                }
            }
            this.headerValues.put(name2, value);
        }
        Matcher matcher = this.request.getMatcher();
        if (matcher != null) {
            name = "tissueName";
            String value = matcher.group(1);
            this.headerValues.put(name, value);
        }
        if (!this.headerValues.containsKey("source") && this.request.getSource() != null) {
            this.headerValues.put("source", this.request.getSource());
        }
        return lineIsHeader;
    }

    @Override
    protected void addHeader(String line) {
        this.columnNames = null;
        this.headerValues = null;
        super.addHeader(line);
    }
}

