/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.io.reader;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geneweaver.domain.EQTL;
import org.geneweaver.domain.Entity;
import org.geneweaver.io.reader.LineIteratorReader;
import org.geneweaver.io.reader.ReaderException;
import org.geneweaver.io.reader.ReaderRequest;
import org.geneweaver.io.reader.UberonService;

class GTExEQTLReader<N extends Entity>
extends LineIteratorReader<N> {
    private static UberonService uberonService = new UberonService();
    private Map<String, Integer> indices;
    private Map<String, EQTL> tissueCache = new HashMap<String, EQTL>();
    private static final Pattern vIdPattern = Pattern.compile("^(chr[0-9XYM]+)_(\\d+)_([A-Z]+)_([A-Z]+)_b38$");

    GTExEQTLReader() {
    }

    @Override
    public GTExEQTLReader<N> init(ReaderRequest request) throws ReaderException {
        super.setup(request);
        this.setDelimiter("\\t");
        return this;
    }

    @Override
    protected N create(String line) throws ReaderException {
        String[] segs = line.split(this.getDelimiter());
        if (line.startsWith("gene_id") || line.startsWith("variant_id")) {
            this.indices = this.parseIndices(segs);
            return null;
        }
        EQTL ret = new EQTL();
        String fullGeneId = segs[this.indices.get("gene_id")];
        ret.setGeneId(this.clean(fullGeneId));
        ret.setFullGeneId(fullGeneId);
        this.setVariantInfo(ret, segs[this.indices.get("variant_id")]);
        ret.setSlope(Double.parseDouble(segs[this.indices.get("slope")]));
        this.setTissueInfoAndCache(ret, this.getCurrentFileName());
        String fileSrc = this.indices.get("gene_id") == 0 ? "eGenes" : "pairs";
        ret.setSource("GTEx (" + fileSrc + ")");
        if (this.indices.containsKey("rs_id_dbsnp151_grch38p7")) {
            ret.setRsId(segs[this.indices.get("rs_id_dbsnp151_grch38p7")]);
        }
        return (N)ret;
    }

    private void setTissueInfoAndCache(EQTL ret, String name) {
        if (this.tissueCache.containsKey(name)) {
            EQTL cached = this.tissueCache.get(name);
            ret.setTissueFileName(cached.getTissueFileName());
            ret.setTissueName(cached.getTissueName());
            ret.setVersion(cached.getVersion());
            ret.setUberon(cached.getUberon());
            return;
        }
        GTExEQTLReader.setTissueInfo(ret, name);
        this.tissueCache.put(name, ret);
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.tissueCache != null) {
            this.tissueCache.clear();
        }
    }

    static void setTissueInfo(EQTL ret, String name) {
        if (name == null) {
            return;
        }
        String[] frags = name.split("\\.");
        String tName = frags[0].replace('_', ' ');
        ret.setTissueFileName(name);
        ret.setTissueName(tName);
        ret.setVersion(frags[1]);
        ret.setUberon(uberonService.getUberonCode(tName));
    }

    private String clean(String geneId) {
        if (geneId.indexOf(46) > 0) {
            return geneId.substring(0, geneId.indexOf(46));
        }
        return geneId;
    }

    private void setVariantInfo(EQTL ret, String varId) {
        ret.setEqtlVariantId(varId);
        String[] sa = this.parseVariantId(varId);
        ret.setChr(sa[0]);
        ret.setRefSeq(sa[2]);
        ret.setAltSeq(sa[3]);
    }

    String[] parseVariantId(String vId) {
        Matcher m = vIdPattern.matcher(vId);
        if (m.matches()) {
            return new String[]{m.group(1), m.group(2), m.group(3), m.group(4)};
        }
        return null;
    }
}

