/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.io.reader;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.beanutils.BeanMap;
import org.geneweaver.domain.Entity;
import org.geneweaver.domain.Gene;
import org.geneweaver.domain.GeneticEntity;
import org.geneweaver.domain.Transcript;
import org.geneweaver.io.connector.GeneConnector;
import org.geneweaver.io.reader.LineIteratorReader;
import org.geneweaver.io.reader.ReaderException;
import org.geneweaver.io.reader.ReaderRequest;

class GeneReader<N extends GeneticEntity>
extends LineIteratorReader<N> {
    GeneReader() {
    }

    @Override
    public GeneReader<N> init(ReaderRequest request) throws ReaderException {
        super.setup(request);
        this.setDelimiter("\t+");
        this.setWindStopType("gene");
        this.setChunkSize(10000);
        return this;
    }

    @Override
    protected N create(String line) throws ReaderException {
        String[] rec = line.split(this.getDelimiter());
        GeneticEntity bean = null;
        String type = rec[2].trim();
        if ("gene".equalsIgnoreCase(type)) {
            bean = new Gene();
        } else if ("transcript".equalsIgnoreCase(type)) {
            bean = new Transcript();
        } else {
            if ("exon".equalsIgnoreCase(type)) {
                return null;
            }
            return null;
        }
        try {
            BeanMap d = new BeanMap((Object)bean);
            this.populate(d, rec);
            d.put((Object)"phase", (Object)rec[7]);
            Map<String, String> attributes = this.parseAttributes(rec[8]);
            String geneId = attributes.get("gene_id").toString().split(":")[0];
            d.put((Object)"geneId", (Object)geneId);
            d.put((Object)"geneName", (Object)attributes.get("gene_name"));
            d.put((Object)"geneVersion", (Object)attributes.get("gene_version"));
            d.put((Object)"geneBiotype", (Object)attributes.get("gene_biotype"));
            this.transfer("transcript_id", attributes, "transcriptId", (Map<Object, Object>)d);
            this.transfer("transcript_biotype", attributes, "transcriptBiotype", (Map<Object, Object>)d);
            this.transfer("transcript_name", attributes, "transcriptName", (Map<Object, Object>)d);
        }
        catch (IllegalArgumentException ne) {
            throw new ReaderException("The line " + line + " of bean type " + bean.getClass().getSimpleName() + " cannot be parsed ", ne);
        }
        return (N)bean;
    }

    @Override
    public <U extends Entity> Function<N, Stream<U>> getDefaultConnector() {
        return new GeneConnector();
    }
}

