/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.io.reader;

import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Stream;
import org.geneweaver.domain.Entity;
import org.geneweaver.domain.HomologGene;
import org.geneweaver.io.connector.HomologConnector;
import org.geneweaver.io.reader.LineIteratorReader;
import org.geneweaver.io.reader.ReaderException;
import org.geneweaver.io.reader.ReaderRequest;

class HomologGeneReader<T extends Entity>
extends LineIteratorReader<T> {
    HomologGeneReader() {
    }

    @Override
    public HomologGeneReader<T> init(ReaderRequest request) throws ReaderException {
        super.setup(request);
        this.setDelimiter("\t+");
        return this;
    }

    @Override
    public <U extends Entity> Function<T, Stream<U>> getDefaultConnector() {
        return new HomologConnector();
    }

    @Override
    protected T create(String line) throws ReaderException {
        if (line.startsWith("HomoloGene ID")) {
            return null;
        }
        if (line.startsWith("DB Class Key")) {
            return null;
        }
        String[] rec = line.split(this.getDelimiter());
        HomologGene gene = new HomologGene();
        gene.setSource(this.request.getSource());
        int i = 0;
        gene.setHid(Long.parseLong(rec[i++]));
        gene.setOrganismName(rec[i++]);
        gene.setTaxonId(Long.parseLong(rec[i++]));
        gene.setSymbol(rec[i++]);
        gene.setEntrezId(Long.parseLong(rec[i++]));
        gene.setMgiId(rec[i++]);
        boolean isHum = gene.getOrganismName().equalsIgnoreCase("human");
        if (isHum && rec.length > 6) {
            gene.setHgncId(rec[i++]);
        }
        if (isHum) {
            if (rec.length > 7) {
                gene.setLocation(rec[i++]);
            }
            if (rec.length > 8) {
                gene.setCoords(rec[i++]);
            }
            if (rec.length > 9) {
                gene.setNucelotideSeqIds(Arrays.asList(rec[i++].split(",")));
            }
            if (rec.length > 10) {
                gene.setProteinSeqIds(Arrays.asList(rec[i++].split(",")));
            }
            if (rec.length > 11) {
                gene.setSwissProtIds(Arrays.asList(rec[i++].split(",")));
            }
        } else {
            if (rec.length > 6) {
                gene.setLocation(rec[i++]);
            }
            if (rec.length > 7) {
                gene.setCoords(rec[i++]);
            }
            if (rec.length > 8) {
                gene.setNucelotideSeqIds(Arrays.asList(rec[i++].split(",")));
            }
            if (rec.length > 9) {
                gene.setProteinSeqIds(Arrays.asList(rec[i++].split(",")));
            }
            if (rec.length > 10) {
                gene.setSwissProtIds(Arrays.asList(rec[i++].split(",")));
            }
        }
        return (T)gene;
    }
}

